/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.velocity;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.OrphanedTrustDetector;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.velocity.ListApplicationLinksContext;
import com.atlassian.applinks.ui.velocity.ListEntityLinksContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Qualifier;

public class VelocityContextFactory {
    private final ApplinksFeatureService applinksFeatureService;
    private final InternalHostApplication internalHostApplication;
    private final BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory;
    private final InternalTypeAccessor typeAccessor;
    private final I18nResolver i18nResolver;
    private final DocumentationLinker documentationLinker;
    private final OrphanedTrustDetector orphanedTrustDetector;
    private final ApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private final MessageFactory messageFactory;
    private final UserManager userManager;

    public VelocityContextFactory(ApplinksFeatureService applinksFeatureService, InternalHostApplication internalHostApplication, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, InternalTypeAccessor typeAccessor, I18nResolver i18nResolver, DocumentationLinker documentationLinker, @Qualifier(value="delegatingOrphanedTrustDetector") OrphanedTrustDetector orphanedTrustDetector, ApplicationLinkService applicationLinkService, ManifestRetriever manifestRetriever, MessageFactory messageFactory, UserManager userManager) {
        this.applinksFeatureService = applinksFeatureService;
        this.internalHostApplication = internalHostApplication;
        this.batchedJSONi18NBuilderFactory = batchedJSONi18NBuilderFactory;
        this.typeAccessor = typeAccessor;
        this.i18nResolver = i18nResolver;
        this.documentationLinker = documentationLinker;
        this.orphanedTrustDetector = orphanedTrustDetector;
        this.applicationLinkService = applicationLinkService;
        this.manifestRetriever = manifestRetriever;
        this.messageFactory = messageFactory;
        this.userManager = userManager;
    }

    public ListApplicationLinksContext buildListApplicationLinksContext(HttpServletRequest request) {
        boolean isSysadmin = this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey());
        boolean hasV3Access = this.applinksFeatureService.isEnabled(ApplinksFeatures.V3_UI_OPT_IN);
        return new ListApplicationLinksContext(this.internalHostApplication, this.batchedJSONi18NBuilderFactory, this.typeAccessor, this.i18nResolver, this.documentationLinker, this.orphanedTrustDetector, request.getContextPath(), isSysadmin, hasV3Access);
    }

    public ListEntityLinksContext buildListEntityLinksContext(HttpServletRequest request, String entityTypeId, String entityKey) {
        boolean isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUserKey(request));
        return new ListEntityLinksContext(this.applicationLinkService, this.manifestRetriever, this.internalHostApplication, this.batchedJSONi18NBuilderFactory, this.documentationLinker, this.i18nResolver, this.messageFactory, this.typeAccessor, entityTypeId, entityKey, request.getContextPath(), this.getUsername(request), isAdmin);
    }

    private String getUsername(HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        return userProfile != null ? userProfile.getUsername() : null;
    }
}

