/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.interceptor;

import com.atlassian.applinks.core.rest.model.ErrorListEntity;
import com.atlassian.applinks.internal.exception.InvalidArgumentException;
import com.atlassian.applinks.internal.exception.NotAuthenticatedException;
import com.atlassian.applinks.internal.exception.PermissionException;
import com.atlassian.applinks.internal.exception.ServiceException;
import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ServiceExceptionInterceptor
implements ResourceInterceptor {
    private static final Response.Status FALLBACK_STATUS = Response.Status.BAD_REQUEST;
    private static final Map<Class<?>, Response.Status> ERROR_TO_CODE = ImmutableMap.of(ServiceException.class, (Object)FALLBACK_STATUS, InvalidArgumentException.class, (Object)Response.Status.BAD_REQUEST, PermissionException.class, (Object)Response.Status.FORBIDDEN, NotAuthenticatedException.class, (Object)Response.Status.UNAUTHORIZED);

    public void intercept(MethodInvocation invocation) throws IllegalAccessException, InvocationTargetException {
        block2: {
            try {
                invocation.invoke();
            }
            catch (InvocationTargetException e) {
                ServiceException serviceException = ServiceExceptionInterceptor.findServiceCause(e);
                if (serviceException == null) break block2;
                invocation.getHttpContext().getResponse().setResponse(ServiceExceptionInterceptor.createResponse(serviceException));
            }
        }
    }

    private static ServiceException findServiceCause(InvocationTargetException e) {
        Throwable cause;
        for (cause = e.getCause(); cause != null && !ServiceException.class.isInstance(cause); cause = cause.getCause()) {
        }
        return (ServiceException)cause;
    }

    private static Response createResponse(ServiceException serviceException) {
        Response.Status status = ServiceExceptionInterceptor.getStatus(serviceException);
        return Response.status((Response.Status)status).entity((Object)new ErrorListEntity(status.getStatusCode(), serviceException.getMessage())).build();
    }

    private static Response.Status getStatus(ServiceException serviceException) {
        for (Class<?> errorClass = serviceException.getClass(); errorClass != null; errorClass = errorClass.getSuperclass()) {
            if (!ERROR_TO_CODE.containsKey(errorClass)) continue;
            return ERROR_TO_CODE.get(errorClass);
        }
        return FALLBACK_STATUS;
    }
}

