/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest;

import com.atlassian.applinks.core.rest.context.ContextInterceptor;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.exception.ServiceException;
import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.applinks.internal.rest.interceptor.ServiceExceptionInterceptor;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="features")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@InterceptorChain(value={ContextInterceptor.class, ServiceExceptionInterceptor.class})
public class ApplinksFeatureResource {
    private final I18nResolver i18nResolver;
    private final ApplinksFeatureService featureService;

    public ApplinksFeatureResource(@Nonnull I18nResolver i18nResolver, @Nonnull ApplinksFeatureService featureService) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.featureService = (ApplinksFeatureService)Preconditions.checkNotNull((Object)featureService, (Object)"featureService");
    }

    @GET
    public Response getAllFeatures() {
        BaseRestEntity.Builder response = new BaseRestEntity.Builder();
        for (ApplinksFeatures feature : ApplinksFeatures.values()) {
            response.add(feature.name(), this.featureService.isEnabled(feature));
        }
        return RestUtil.ok(response.build());
    }

    @GET
    @Path(value="/{featureName}")
    public Response isEnabled(@PathParam(value="featureName") String featureName) {
        featureName = Strings.nullToEmpty((String)featureName);
        ApplinksFeatures feature = this.parseFeature(featureName);
        return RestUtil.ok(BaseRestEntity.createSingleFieldEntity(featureName, this.featureService.isEnabled(feature)));
    }

    @PUT
    @Path(value="/{featureName}")
    public Response enable(@PathParam(value="featureName") String featureName) throws ServiceException {
        featureName = Strings.nullToEmpty((String)featureName);
        ApplinksFeatures feature = this.parseFeature(featureName);
        this.featureService.enable(feature, new ApplinksFeatures[0]);
        return RestUtil.ok(BaseRestEntity.createSingleFieldEntity(featureName, true));
    }

    @DELETE
    @Path(value="/{featureName}")
    public Response disable(@PathParam(value="featureName") String featureName) throws ServiceException {
        featureName = Strings.nullToEmpty((String)featureName);
        ApplinksFeatures feature = this.parseFeature(featureName);
        this.featureService.disable(feature, new ApplinksFeatures[0]);
        return RestUtil.noContent();
    }

    private ApplinksFeatures parseFeature(String featureName) {
        try {
            return ApplinksFeatures.valueOf(featureName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(this.badFeatureName(featureName));
        }
    }

    private Response badFeatureName(String featureName) {
        return RestUtil.badRequest(this.i18nResolver.getText("applinks.rest.feature.error.unsupported", new Serializable[]{featureName}));
    }
}

