/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.feature;

import com.atlassian.applinks.internal.exception.DefaultServiceExceptionFactory;
import com.atlassian.applinks.internal.exception.NoAccessException;
import com.atlassian.applinks.internal.exception.NotAuthenticatedException;
import com.atlassian.applinks.internal.exception.PermissionException;
import com.atlassian.applinks.internal.exception.ServiceExceptionFactory;
import com.atlassian.applinks.internal.exception.SystemFeatureException;
import com.atlassian.applinks.internal.feature.ApplinksFeatureService;
import com.atlassian.applinks.internal.feature.ApplinksFeatures;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;

public class DefaultApplinksFeatureService
implements ApplinksFeatureService {
    private final DarkFeatureManager darkFeatureManager;
    private final ServiceExceptionFactory serviceExceptionFactory;
    private final UserManager userManager;

    public DefaultApplinksFeatureService(@Nonnull DarkFeatureManager darkFeatureManager, @Nonnull DefaultServiceExceptionFactory serviceExceptionFactory, @Nonnull UserManager userManager) {
        this.serviceExceptionFactory = serviceExceptionFactory;
        this.darkFeatureManager = (DarkFeatureManager)Preconditions.checkNotNull((Object)darkFeatureManager);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    @Override
    public boolean isEnabled(@Nonnull ApplinksFeatures feature) {
        Preconditions.checkNotNull((Object)((Object)feature), (Object)"feature");
        if (feature.isSystem()) {
            return (Boolean)Objects.firstNonNull((Object)BooleanUtils.toBooleanObject((String)System.getProperty("atlassian.darkfeature." + feature.featureKey)), (Object)feature.getDefaultValue());
        }
        return this.darkFeatureManager.isFeatureEnabledForCurrentUser(feature.featureKey);
    }

    @Override
    public void enable(@Nonnull ApplinksFeatures feature, ApplinksFeatures ... moreFeatures) throws NoAccessException, SystemFeatureException {
        Preconditions.checkNotNull((Object)((Object)feature), (Object)"feature");
        Preconditions.checkNotNull((Object)moreFeatures, (Object)"moreFeatures");
        this.validateNoSystemFeatures(feature, moreFeatures);
        this.validateIsAdmin();
        this.enableFeature(feature);
        for (ApplinksFeatures more : moreFeatures) {
            this.enableFeature(more);
        }
    }

    @Override
    public void disable(@Nonnull ApplinksFeatures feature, ApplinksFeatures ... moreFeatures) throws NoAccessException, SystemFeatureException {
        Preconditions.checkNotNull((Object)((Object)feature), (Object)"feature");
        Preconditions.checkNotNull((Object)moreFeatures, (Object)"moreFeatures");
        this.validateNoSystemFeatures(feature, moreFeatures);
        this.validateIsAdmin();
        this.disableFeature(feature);
        for (ApplinksFeatures more : moreFeatures) {
            this.disableFeature(more);
        }
    }

    private void enableFeature(@Nonnull ApplinksFeatures feature) {
        this.darkFeatureManager.enableFeatureForAllUsers(feature.featureKey);
    }

    private void disableFeature(@Nonnull ApplinksFeatures feature) {
        this.darkFeatureManager.disableFeatureForAllUsers(feature.featureKey);
    }

    private void validateNoSystemFeatures(ApplinksFeatures feature, ApplinksFeatures ... moreFeatures) throws SystemFeatureException {
        EnumSet<ApplinksFeatures> systemFeatures = EnumSet.noneOf(ApplinksFeatures.class);
        if (feature.isSystem()) {
            systemFeatures.add(feature);
        }
        for (ApplinksFeatures more : moreFeatures) {
            if (!more.isSystem()) continue;
            systemFeatures.add(more);
        }
        if (!systemFeatures.isEmpty()) {
            throw this.serviceExceptionFactory.create(SystemFeatureException.class, new Serializable[]{((Object)systemFeatures).toString()});
        }
    }

    private void validateIsAdmin() throws NoAccessException {
        UserKey user = this.userManager.getRemoteUserKey();
        this.validateAuthenticated(user);
        if (!this.userManager.isAdmin(user)) {
            throw this.serviceExceptionFactory.create(PermissionException.class, new Serializable[]{user});
        }
    }

    private void validateAuthenticated(UserKey user) throws NotAuthenticatedException {
        if (user == null) {
            throw this.serviceExceptionFactory.create(NotAuthenticatedException.class, new Serializable[0]);
        }
    }
}

