/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.twolo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderUtil;
import com.atlassian.applinks.core.auth.oauth.twolo.TwoLeggedOAuthRequest;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;

public class TwoLeggedOAuthRequestFactoryImpl
implements ApplicationLinkRequestFactory {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ApplicationLink applicationLink;
    private final ConsumerService consumerService;
    private final RequestFactory requestFactory;

    public TwoLeggedOAuthRequestFactoryImpl(ApplicationLink applicationLink, AuthenticationConfigurationManager authenticationConfigurationManager, ConsumerService consumerService, RequestFactory requestFactory) {
        this.applicationLink = (ApplicationLink)Preconditions.checkNotNull((Object)applicationLink);
        this.authenticationConfigurationManager = (AuthenticationConfigurationManager)Preconditions.checkNotNull((Object)authenticationConfigurationManager);
        this.consumerService = (ConsumerService)Preconditions.checkNotNull((Object)consumerService);
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
    }

    public ApplicationLinkRequest createRequest(Request.MethodType methodType, String uri) throws CredentialsRequiredException {
        Map config = this.authenticationConfigurationManager.getConfiguration(this.applicationLink.getId(), OAuthAuthenticationProvider.class);
        if (config == null) {
            throw new IllegalStateException(String.format("OAuth Authentication is not configured for application link %s", this.applicationLink));
        }
        ServiceProvider serviceProvider = ServiceProviderUtil.getServiceProvider(config, this.applicationLink);
        Request request = this.requestFactory.createRequest(methodType, uri);
        return new TwoLeggedOAuthRequest(uri, methodType, request, serviceProvider, this.consumerService, this.applicationLink.getId());
    }

    public URI getAuthorisationURI() {
        return null;
    }

    public URI getAuthorisationURI(URI callback) {
        return null;
    }
}

