/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.twolo;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.RequestUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationDirection;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.auth.IncomingTrustAuthenticationProviderPluginModule;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Version;

public abstract class AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule
implements AuthenticationProviderPluginModule,
IncomingTrustAuthenticationProviderPluginModule {
    private final InternalHostApplication hostApplication;

    public AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule(InternalHostApplication hostApplication) {
        this.hostApplication = hostApplication;
    }

    public String getConfigUrl(ApplicationLink link, Version applicationLinksVersion, AuthenticationDirection direction, HttpServletRequest request) {
        boolean supportsAppLinks = applicationLinksVersion != null;
        boolean oAuthPluginInstalled = OAuthHelper.isOAuthPluginInstalled(link);
        if (direction == AuthenticationDirection.INBOUND) {
            if (supportsAppLinks || oAuthPluginInstalled) {
                return RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + "/plugins/servlet/applinks/auth/conf/oauth/add-consumer-by-url/" + link.getId().toString() + "?" + "uiposition" + "=local";
            }
            return RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + "/plugins/servlet/applinks/auth/conf/oauth/add-consumer-manually/" + link.getId().toString();
        }
        return null;
    }

    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass() {
        return OAuthAuthenticationProvider.class;
    }
}

