/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    public static URI getBaseURLFromRequest(HttpServletRequest request, URI baseUrl) {
        try {
            StringBuilder urlBuilder = new StringBuilder();
            String scheme = request.getScheme();
            urlBuilder.append(scheme);
            urlBuilder.append("://");
            urlBuilder.append(request.getServerName());
            int port = request.getServerPort();
            if (!RequestUtil.isStandardPort(scheme, port)) {
                urlBuilder.append(":");
                urlBuilder.append(port);
            }
            urlBuilder.append(request.getContextPath());
            return new URI(urlBuilder.toString());
        }
        catch (Exception ex) {
            return baseUrl;
        }
    }

    public static int getDefaultPort(String scheme) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME)) {
            return 80;
        }
        if (scheme.equalsIgnoreCase(HTTPS_SCHEME)) {
            return 443;
        }
        return -1;
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME) && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase(HTTPS_SCHEME) && port == 443;
    }
}

