/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.oauth.consumer.ConsumerTokenStore;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class DefaultConsumerTokenStoreService
implements ConsumerTokenStoreService {
    private final ConsumerTokenStore consumerTokenStore;
    private final AuthenticationConfigurationManager configurationManager;
    private final ConsumerService consumerService;
    private static final String APPLINKS_APPLICATION_LINK_ID = "applinks.oauth.applicationLinkId";

    public DefaultConsumerTokenStoreService(ConsumerTokenStore consumerTokenStore, AuthenticationConfigurationManager configurationManager, ConsumerService consumerService) {
        this.consumerTokenStore = consumerTokenStore;
        this.configurationManager = configurationManager;
        this.consumerService = consumerService;
    }

    @Override
    public void addConsumerToken(ApplicationLink applicationLink, String username, ConsumerToken consumerToken) {
        Preconditions.checkNotNull((Object)applicationLink, (Object)"applicationLink");
        Preconditions.checkNotNull((Object)username, (Object)"username");
        Preconditions.checkNotNull((Object)consumerToken, (Object)"consumerToken");
        this.verifyOAuthOutgoingEnabled(applicationLink.getId());
        HashMap<String, String> tokenProperties = new HashMap<String, String>();
        tokenProperties.put(APPLINKS_APPLICATION_LINK_ID, applicationLink.getId().get());
        ConsumerTokenStore.Key key = DefaultConsumerTokenStoreService.makeOAuthApplinksConsumerKey(username, applicationLink.getId().get());
        ConsumerToken.ConsumerTokenBuilder tokenBuilder = consumerToken.isAccessToken() ? ConsumerToken.newAccessToken((String)consumerToken.getToken()) : ConsumerToken.newRequestToken((String)consumerToken.getToken());
        ((ConsumerToken.ConsumerTokenBuilder)((ConsumerToken.ConsumerTokenBuilder)tokenBuilder.tokenSecret(consumerToken.getTokenSecret())).consumer(consumerToken.getConsumer())).properties(tokenProperties);
        this.consumerTokenStore.put(key, tokenBuilder.build());
    }

    @Override
    public void removeAllConsumerTokens(ApplicationLink applicationLink) {
        Preconditions.checkNotNull((Object)applicationLink, (Object)"applicationLink");
        Map configuration = this.configurationManager.getConfiguration(applicationLink.getId(), OAuthAuthenticationProvider.class);
        this.verifyOAuthOutgoingEnabled(applicationLink.getId());
        if (configuration.containsKey("consumerKey.outbound")) {
            String consumerKey = (String)configuration.get("consumerKey.outbound");
            this.consumerTokenStore.removeTokensForConsumer(consumerKey);
        } else {
            String consumerKey = this.consumerService.getConsumer().getKey();
            Map consumerTokens = this.consumerTokenStore.getConsumerTokens(consumerKey);
            for (ConsumerTokenStore.Key key : consumerTokens.keySet()) {
                Map tokenProperties = ((ConsumerToken)consumerTokens.get(key)).getProperties();
                if (!tokenProperties.containsKey(APPLINKS_APPLICATION_LINK_ID) || !((String)tokenProperties.get(APPLINKS_APPLICATION_LINK_ID)).equals(applicationLink.getId().get())) continue;
                this.consumerTokenStore.remove(key);
            }
        }
    }

    @Override
    public boolean removeConsumerToken(ApplicationId applicationId, String username) {
        Preconditions.checkNotNull((Object)applicationId, (Object)"applicationLink");
        this.verifyOAuthOutgoingEnabled(applicationId);
        ConsumerTokenStore.Key key = DefaultConsumerTokenStoreService.makeOAuthApplinksConsumerKey(username, applicationId.get());
        if (this.consumerTokenStore.get(key) != null) {
            this.consumerTokenStore.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public ConsumerToken getConsumerToken(ApplicationLink applicationLink, String username) {
        Preconditions.checkNotNull((Object)username, (Object)"Username cannot be null!");
        Preconditions.checkNotNull((Object)applicationLink, (Object)"Application Link cannot be null!");
        this.verifyOAuthOutgoingEnabled(applicationLink.getId());
        return this.consumerTokenStore.get(DefaultConsumerTokenStoreService.makeOAuthApplinksConsumerKey(username, applicationLink.getId().get()));
    }

    public static ConsumerTokenStore.Key makeOAuthApplinksConsumerKey(String username, String applicationLinkId) {
        Preconditions.checkNotNull((Object)username, (Object)"Username cannot be null!");
        Preconditions.checkNotNull((Object)applicationLinkId, (Object)"Application Link Id cannot be null!");
        return new ConsumerTokenStore.Key(applicationLinkId + ":" + username);
    }

    @Override
    public boolean isOAuthOutgoingEnabled(ApplicationId applicationId) {
        return this.configurationManager.isConfigured(applicationId, OAuthAuthenticationProvider.class);
    }

    private void verifyOAuthOutgoingEnabled(ApplicationId applicationId) {
        if (!this.isOAuthOutgoingEnabled(applicationId)) {
            throw new IllegalStateException("OAuth not enabled for outgoing authentication!");
        }
    }
}

