/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkUIService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class DefaultApplicationLinkUIService
implements ApplicationLinkUIService {
    private static final String REQUEST_BANNER_TEMPLATE = "templates/fragments/auth_request_banner.vm";
    private static final String REQUEST_INLINE_TEMPLATE = "templates/fragments/auth_request_inline.vm";
    private final I18nResolver i18nResolver;
    private final TemplateRenderer templateRenderer;

    public DefaultApplicationLinkUIService(I18nResolver i18nResolver, TemplateRenderer templateRenderer) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
    }

    public ApplicationLinkUIService.MessageBuilder authorisationRequest(ApplicationLink appLink) {
        return new AuthRequestMessageBuilder((ApplicationLink)Preconditions.checkNotNull((Object)appLink, (Object)"appLink"));
    }

    private class AuthRequestMessageBuilder
    implements ApplicationLinkUIService.MessageBuilder {
        private final ApplicationLink appLink;
        private ApplicationLinkUIService.MessageFormat format = ApplicationLinkUIService.MessageFormat.BANNER;
        private String contentHtml = "";

        AuthRequestMessageBuilder(ApplicationLink appLink) {
            this.appLink = appLink;
        }

        public ApplicationLinkUIService.MessageBuilder format(ApplicationLinkUIService.MessageFormat format) {
            this.format = (ApplicationLinkUIService.MessageFormat)Preconditions.checkNotNull((Object)format, (Object)"format");
            return this;
        }

        public ApplicationLinkUIService.MessageBuilder contentHtml(String contentHtml) {
            this.contentHtml = (String)Preconditions.checkNotNull((Object)contentHtml, (Object)"contentHtml");
            return this;
        }

        public String getHtml() {
            String messageHtml;
            String template;
            String applinkId = this.appLink.getId().toString();
            String appName = this.appLink.getName();
            String appUri = this.appLink.getDisplayUrl().toString();
            String authUri = this.appLink.createAuthenticatedRequestFactory().getAuthorisationURI().toString();
            switch (this.format) {
                case INLINE: {
                    template = DefaultApplicationLinkUIService.REQUEST_INLINE_TEMPLATE;
                    messageHtml = DefaultApplicationLinkUIService.this.i18nResolver.getText("applinks.util.auth.request.inline", new Serializable[]{StringEscapeUtils.escapeHtml((String)authUri)});
                    break;
                }
                default: {
                    template = DefaultApplicationLinkUIService.REQUEST_BANNER_TEMPLATE;
                    messageHtml = DefaultApplicationLinkUIService.this.i18nResolver.getText("applinks.util.auth.request", new Serializable[]{StringEscapeUtils.escapeHtml((String)authUri), StringEscapeUtils.escapeHtml((String)appUri), StringEscapeUtils.escapeHtml((String)appName)});
                }
            }
            StringWriter buf = new StringWriter();
            ImmutableMap.Builder contextBuilder = ImmutableMap.builder().put((Object)"applinkId", (Object)applinkId).put((Object)"appName", (Object)appName).put((Object)"appUri", (Object)appUri).put((Object)"authUri", (Object)authUri).put((Object)"messageHtml", (Object)messageHtml).put((Object)"contentHtml", (Object)this.contentHtml);
            try {
                DefaultApplicationLinkUIService.this.templateRenderer.render(template, (Map)contextBuilder.build(), (Writer)buf);
            }
            catch (IOException e) {
                // empty catch block
            }
            return buf.toString();
        }
    }
}

