/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.retriever;

import com.atlassian.applinks.accesslevel.core.retriever.RemoteAuthFailure;
import com.atlassian.applinks.api.ApplicationLinkRequest;

public class AuthorizationFailedException
extends Exception
implements RemoteAuthFailure {
    private Class<? extends ApplicationLinkRequest> requestClass;
    private final int remoteStatusCode;
    private final String remoteStatusMessage;
    private String authorizationProblem;
    private String authorizationProblemAdvice;

    public AuthorizationFailedException(Class<? extends ApplicationLinkRequest> requestClass, String message, int remoteStatusCode, String authorizationProblem, String authorizationProblemAdvice) {
        super(message);
        this.requestClass = requestClass;
        this.remoteStatusCode = remoteStatusCode;
        this.remoteStatusMessage = message;
        this.authorizationProblem = authorizationProblem;
        this.authorizationProblemAdvice = authorizationProblemAdvice;
    }

    @Override
    public int getRemoteStatusCode() {
        return this.remoteStatusCode;
    }

    @Override
    public String getRemoteStatusMessage() {
        return this.remoteStatusMessage;
    }

    @Override
    public String getRequestTypeName() {
        return "applinks.accesslevel.request.type." + this.requestClass.getSimpleName().toLowerCase();
    }

    @Override
    public String getAuthProblemAdvice() {
        return this.authorizationProblemAdvice;
    }

    @Override
    public String getAuthProblem() {
        return this.authorizationProblem;
    }
}

