/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.retriever;

import com.atlassian.applinks.accesslevel.core.retriever.RemoteAuthFailure;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;

public class AuthenticationFailedException
extends CredentialsRequiredException
implements RemoteAuthFailure {
    private final int remoteStatusCode;
    private final String remoteStatusMessage;
    private final String authenticationProblem;
    private final String authenticationProblemAdvice;
    private final Class<? extends ApplicationLinkRequest> requestClass;

    public AuthenticationFailedException(AuthorisationURIGenerator authorisationURIGenerator, Class<? extends ApplicationLinkRequest> requestClass, String message, int remoteStatusCode, String authenticationProblem, String authenticationProblemAdvice) {
        super(authorisationURIGenerator, message);
        this.requestClass = requestClass;
        this.remoteStatusCode = remoteStatusCode;
        this.remoteStatusMessage = message;
        this.authenticationProblem = authenticationProblem;
        this.authenticationProblemAdvice = authenticationProblemAdvice;
    }

    @Override
    public int getRemoteStatusCode() {
        return this.remoteStatusCode;
    }

    @Override
    public String getRemoteStatusMessage() {
        return this.remoteStatusMessage;
    }

    @Override
    public String getAuthProblemAdvice() {
        return this.authenticationProblemAdvice;
    }

    @Override
    public String getAuthProblem() {
        return this.authenticationProblem;
    }

    @Override
    public String getRequestTypeName() {
        return "applinks.accesslevel.request.type." + this.requestClass.getSimpleName().toLowerCase();
    }
}

