/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.rest.model;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@XmlRootElement(name="accessLevelUIEntity")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE)
public class AccessLevelUIInstructionsEntity {
    @XmlElement(name="areAccessLevelsSupported")
    private Boolean areAccessLevelsSupported = true;
    @XmlElement(name="unsupportedReasons")
    private List<String> unsupportedReasons;
    @XmlElement(name="isEditable")
    private Boolean isEditable;

    public AccessLevelUIInstructionsEntity() {
    }

    public AccessLevelUIInstructionsEntity(ApplicationLink applicationLink, Pair<AccessLevel, Iterable<String>> incoming, Pair<AccessLevel, Iterable<String>> outgoing, @Nullable I18nResolver i18nResolver) {
        this(applicationLink.isSystem(), incoming, outgoing, i18nResolver);
    }

    public AccessLevelUIInstructionsEntity(Boolean isSystem, Pair<AccessLevel, Iterable<String>> incoming, Pair<AccessLevel, Iterable<String>> outgoing, I18nResolver i18nResolver) {
        this.unsupportedReasons = Lists.newArrayList();
        if (this.isSystemLink(isSystem)) {
            this.isEditable = false;
            this.areAccessLevelsSupported = false;
            this.unsupportedReasons.add(i18nResolver != null ? i18nResolver.getText("applinks.accesslevel.linknoteditable.system") : "applinks.accesslevel.linknoteditable.system");
            return;
        }
        this.isEditable = true;
        if (((AccessLevel)((Object)incoming.left())).level < 0 || ((AccessLevel)((Object)outgoing.left())).level < 0) {
            this.areAccessLevelsSupported = false;
            this.unsupportedReasons.addAll(Lists.newArrayList((Iterable)((Iterable)incoming.right())));
            this.unsupportedReasons.addAll(Lists.newArrayList((Iterable)((Iterable)outgoing.right())));
        }
    }

    private boolean isSystemLink(Boolean isSystem) {
        return isSystem != null && isSystem != false;
    }

    public Boolean getAreAccessLevelsSupported() {
        return this.areAccessLevelsSupported;
    }

    public Boolean IsEditable() {
        return this.isEditable;
    }
}

