/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.AccessLevelAwareApplicationLinkService;
import com.atlassian.applinks.accesslevel.core.rest.ApplicationLinkResourceLocal;
import com.atlassian.applinks.accesslevel.core.rest.model.AccessLevelApplicationLinkEntity;
import com.atlassian.applinks.accesslevel.core.rest.model.RemoteAccessLevelApplicationLinkUIEntity;
import com.atlassian.applinks.accesslevel.core.retriever.AuthenticationFailedException;
import com.atlassian.applinks.accesslevel.core.retriever.AuthorizationFailedException;
import com.atlassian.applinks.accesslevel.core.retriever.AuthorizationRequiredException;
import com.atlassian.applinks.accesslevel.core.retriever.BadContentException;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteAccessLevelApplicationLinkEntityRetriever;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteApplicationLinkAuthenticationEntityRetriever;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteApplicationLinkEntityRetriever;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteAuthFailure;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteEntityRetriever;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteRequestException;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.core.rest.permission.PermissionCode;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.rest.interceptor.V3UiInterceptor;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="config/remote")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
@InterceptorChain(value={V3UiInterceptor.class})
public class ApplicationLinkResourceRemote {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApplicationLinkResourceLocal.class.getName());
    private final ApplicationLinkService applicationLinkService;
    private final AccessLevelAwareApplicationLinkService accessLevelAwareApplicationLinkService;
    private final InternalHostApplication internalHostApplication;
    private UserManager userManager;
    private I18nResolver i18nResolver;

    public ApplicationLinkResourceRemote(ApplicationLinkService applicationLinkService, InternalHostApplication internalHostApplication, UserManager userManager, AccessLevelAwareApplicationLinkService accessLevelAwareApplicationLinkService, I18nResolver i18nResolver) {
        this.applicationLinkService = applicationLinkService;
        this.internalHostApplication = internalHostApplication;
        this.userManager = userManager;
        this.accessLevelAwareApplicationLinkService = accessLevelAwareApplicationLinkService;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @Path(value="{id}")
    @AnonymousAllowed
    public Response getRemote(@PathParam(value="id") String id) throws URISyntaxException, TypeNotInstalledException, ResponseException {
        ApplicationLink applicationLink = this.getApplicationLink(id);
        if (applicationLink == null) {
            LOG.debug("Unable to find application link with id '{}' giving up.", (Object)id);
            return Response.serverError().entity((Object)("Unable to retrieve link with id: " + id)).build();
        }
        LOG.debug("Found application link with id '{}' RPC Url '{}'.", (Object)id, (Object)applicationLink.getRpcUrl());
        ApplicationId ourRealAppId = this.internalHostApplication.getId();
        ApplicationId ourBaseAppId = ApplicationIdUtil.generate((URI)this.internalHostApplication.getBaseUrl());
        Option<Response> fullSupportResponse = this.getFullSupportResponse(applicationLink, ourRealAppId, ourBaseAppId);
        if (fullSupportResponse.isDefined()) {
            return (Response)fullSupportResponse.get();
        }
        Option<Response> legacySupportResponse = this.getLegacySupportResponse(applicationLink, ourRealAppId, ourBaseAppId);
        if (legacySupportResponse.isDefined()) {
            return (Response)legacySupportResponse.get();
        }
        LOG.debug("Application link '{}'. AccessLevel unknown.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
        return Response.ok().entity((Object)new RemoteAccessLevelApplicationLinkUIEntity(500, this.getNonNullMessages(Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.remote.unsupported"})), this.userManager.getRemoteUser().getUsername(), null, this.getSelfLink(id))).build();
    }

    private Option<Response> getLegacySupportResponse(ApplicationLink applicationLink, ApplicationId ourRealAppId, ApplicationId ourBaseAppId) throws URISyntaxException {
        LOG.debug("Application link '{}'. Attempt to retrieve remote config using legacy REST resources.", (Object)applicationLink.getId().get());
        LOG.debug("Application link '{}'. Make request using real host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
        RemoteApplicationLinkEntityRetriever realIdEntityCall = new RemoteApplicationLinkEntityRetriever(ourRealAppId, applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity entity = this.getRemoteApplicationLinkEntity(realIdEntityCall);
        if (entity.getRemoteStatus().getCode() == 401) {
            LOG.debug("Application link '{}'. Remote config retrieval failed due to authentication issues using host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)entity).build());
        }
        RemoteApplicationLinkAuthenticationEntityRetriever realIdAuthCall = new RemoteApplicationLinkAuthenticationEntityRetriever(ourRealAppId, applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity idEntity = this.getRemoteAccessLevelApplicationLinkEntity(realIdAuthCall, entity);
        if (idEntity.getRemoteStatus().getCode() == 200) {
            LOG.debug("Application link '{}'. Remote config retrieved using host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)idEntity).build());
        }
        RemoteApplicationLinkEntityRetriever realIdEntityCalla = new RemoteApplicationLinkEntityRetriever(ourBaseAppId, applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity entity1a = this.getRemoteApplicationLinkEntity(realIdEntityCalla);
        if (entity.getRemoteStatus().getCode() == 401) {
            LOG.debug("Application link '{}'. Remote config retrieval failed due to authentication issues using host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)entity1a).build());
        }
        LOG.debug("Application link '{}'. Make request using baseUrl host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourBaseAppId.get());
        RemoteApplicationLinkAuthenticationEntityRetriever realIdAuthCalla = new RemoteApplicationLinkAuthenticationEntityRetriever(ourBaseAppId, applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity baseUrlEntity = this.getRemoteAccessLevelApplicationLinkEntity(realIdAuthCalla, entity1a);
        if (baseUrlEntity.getRemoteStatus().getCode() == 200) {
            LOG.debug("Application link '{}'. Remote config retrieved using baseUrl id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)baseUrlEntity).build());
        }
        LOG.debug("Application link '{}'. Unable to retrieve Remote config use baseUrl Id, fallback to returning response from using real id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
        return Option.none();
    }

    private Option<Response> getFullSupportResponse(ApplicationLink applicationLink, ApplicationId ourRealAppId, ApplicationId ourBaseAppId) throws URISyntaxException {
        LOG.debug("Application link '{}'. Attempt to retrieve remote config using new REST resources.", (Object)applicationLink.getId().get());
        LOG.debug("Application link '{}'. Make request using real host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
        RemoteAccessLevelApplicationLinkEntityRetriever realIdLevelCall = new RemoteAccessLevelApplicationLinkEntityRetriever(ourRealAppId.toString(), applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity idEntity = this.getRemoteAccessLevelApplicationLinkEntity(realIdLevelCall);
        if (idEntity.getRemoteStatus().getCode() == 200) {
            LOG.debug("Application link '{}'. Remote config retrieved using host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)idEntity).build());
        }
        LOG.debug("Application link '{}'. Make request using baseUrl host id '{}'.", (Object)applicationLink.getId().get(), (Object)ourBaseAppId.get());
        RemoteAccessLevelApplicationLinkEntityRetriever baseIdLevelCall = new RemoteAccessLevelApplicationLinkEntityRetriever(ourBaseAppId.toString(), applicationLink);
        RemoteAccessLevelApplicationLinkUIEntity baseUrlEntity = this.getRemoteAccessLevelApplicationLinkEntity(baseIdLevelCall);
        if (baseUrlEntity.getRemoteStatus().getCode() == 200) {
            LOG.debug("Application link '{}'. Remote config retrieved using baseUrl id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
            return Option.some((Object)Response.ok((Object)baseUrlEntity).build());
        }
        LOG.debug("Application link '{}'. Unable to retrieve Remote config use baseUrl Id, fallback to returning response from using real id '{}'.", (Object)applicationLink.getId().get(), (Object)ourRealAppId.get());
        return Option.none();
    }

    private RemoteAccessLevelApplicationLinkUIEntity getRemoteApplicationLinkEntity(RemoteEntityRetriever<ApplicationLinkEntity> applinkCall) {
        try {
            LOG.debug("Make Anonymous request to retrieve RemoteAccessLevelApplicationLinkUIEntity from '{}'.", (Object)applinkCall.getEndpoint());
            if (applinkCall.executeAuthenticated()) {
                return new RemoteAccessLevelApplicationLinkUIEntity(applinkCall.getContent(), 200, null, null, null, null, this.i18nResolver);
            }
            return new RemoteAccessLevelApplicationLinkUIEntity();
        }
        catch (AuthorizationRequiredException e) {
            return this.getAuthorizationEntity(e);
        }
        catch (AuthorizationFailedException e) {
            return this.getAuthorizationFailureEntity(e);
        }
        catch (BadContentException e) {
            return this.getBadContentEntity(e);
        }
        catch (AuthenticationFailedException e) {
            return this.getAuthenticationFailedEntity(e);
        }
        catch (RemoteRequestException e) {
            return this.getRequestFailedEntity(e);
        }
    }

    private RemoteAccessLevelApplicationLinkUIEntity getRemoteAccessLevelApplicationLinkEntity(RemoteEntityRetriever<ApplicationLinkAuthenticationEntity> applinkCall, RemoteAccessLevelApplicationLinkUIEntity remoteAccessLevelApplicationLinkUIEntity) throws URISyntaxException {
        try {
            LOG.debug("Make Authenticated request to retrieve RemoteAccessLevelApplicationLinkUIEntity from '{}'.", (Object)applinkCall.getEndpoint());
            if (applinkCall.executeAuthenticated()) {
                return new RemoteAccessLevelApplicationLinkUIEntity(remoteAccessLevelApplicationLinkUIEntity.getId(), remoteAccessLevelApplicationLinkUIEntity.getTypeId(), remoteAccessLevelApplicationLinkUIEntity.getName(), remoteAccessLevelApplicationLinkUIEntity.getDisplayUrl(), remoteAccessLevelApplicationLinkUIEntity.getIconUrl(), remoteAccessLevelApplicationLinkUIEntity.getIconUri(), remoteAccessLevelApplicationLinkUIEntity.getRpcUrl(), remoteAccessLevelApplicationLinkUIEntity.isPrimary(), remoteAccessLevelApplicationLinkUIEntity.isSystem(), this.accessLevelAwareApplicationLinkService.getRemoteInstanceIncomingAccessLevel(applinkCall.getContent()), this.accessLevelAwareApplicationLinkService.getRemoteInstanceOutgoingAccessLevel(applinkCall.getContent()), (Pair<AccessLevel, Iterable<String>>)new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.outgoing.operating.notyetimplemented")})), 200, null, null, null, null, this.i18nResolver);
            }
            return new RemoteAccessLevelApplicationLinkUIEntity();
        }
        catch (AuthorizationRequiredException e) {
            return this.getAuthorizationEntity(e);
        }
        catch (AuthorizationFailedException e) {
            return this.getAuthorizationFailureEntity(e);
        }
        catch (BadContentException e) {
            return this.getBadContentEntity(e);
        }
        catch (AuthenticationFailedException e) {
            return this.getAuthenticationFailedEntity(e);
        }
        catch (RemoteRequestException e) {
            return this.getRequestFailedEntity(e);
        }
    }

    private RemoteAccessLevelApplicationLinkUIEntity getRemoteAccessLevelApplicationLinkEntity(RemoteEntityRetriever<AccessLevelApplicationLinkEntity> applinkCall) throws URISyntaxException {
        try {
            LOG.debug("Make Anonymous request to retrieve RemoteAccessLevelApplicationLinkUIEntity from '{}'.", (Object)applinkCall.getEndpoint());
            if (applinkCall.executeAnonymous()) {
                return new RemoteAccessLevelApplicationLinkUIEntity(applinkCall.getContent(), 200, null, null, null, this.getSelfLink(applinkCall.getApplicationLink().getId().get()), this.i18nResolver);
            }
            return new RemoteAccessLevelApplicationLinkUIEntity();
        }
        catch (AuthorizationRequiredException e) {
            return this.getAuthorizationEntity(e);
        }
        catch (AuthorizationFailedException e) {
            return this.getAuthorizationFailureEntity(e);
        }
        catch (BadContentException e) {
            return this.getBadContentEntity(e);
        }
        catch (AuthenticationFailedException e) {
            return this.getAuthenticationFailedEntity(e);
        }
        catch (RemoteRequestException e) {
            return this.getRequestFailedEntity(e);
        }
    }

    private ApplicationLink getApplicationLink(String id) throws TypeNotInstalledException {
        ApplicationId remoteAppId = new ApplicationId(id);
        return this.applicationLinkService.getApplicationLink(remoteAppId);
    }

    private Link getSelfLink(String id) throws URISyntaxException {
        return Link.self((URI)this.getSelfUri(id));
    }

    private URI getSelfUri(String id) throws URISyntaxException {
        return new URI("config/remote/" + id);
    }

    private RemoteAccessLevelApplicationLinkUIEntity getAuthenticationFailedEntity(AuthenticationFailedException e) {
        return new RemoteAccessLevelApplicationLinkUIEntity(e.getRemoteStatusCode(), this.getNonNullMessages(e), this.userManager.getRemoteUser().getUsername(), this.getRequestTypeMessage(e.getRequestTypeName()), null);
    }

    private RemoteAccessLevelApplicationLinkUIEntity getBadContentEntity(BadContentException e) {
        return new RemoteAccessLevelApplicationLinkUIEntity(e.getRemoteStatusCode(), this.getNonNullMessages(Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.remote.unknown", e.getRemoteStatusMessage()})), this.userManager.getRemoteUser().getUsername(), this.getRequestTypeMessage(e.getRequestTypeName()), null);
    }

    private RemoteAccessLevelApplicationLinkUIEntity getAuthorizationFailureEntity(AuthorizationFailedException e) {
        return new RemoteAccessLevelApplicationLinkUIEntity(e.getRemoteStatusCode(), this.getNonNullMessages(e), this.userManager.getRemoteUser().getUsername(), this.getRequestTypeMessage(e.getRequestTypeName()), null);
    }

    private RemoteAccessLevelApplicationLinkUIEntity getAuthorizationEntity(AuthorizationRequiredException e) {
        return new RemoteAccessLevelApplicationLinkUIEntity(e.getRemoteStatusCode() == 0 ? 401 : e.getRemoteStatusCode(), this.getNonNullMessages(e), this.userManager.getRemoteUser().getUsername(), this.getRequestTypeMessage(e.getRequestTypeName()), Link.link((URI)e.getAuthorisationURI(this.getOAuthAuthorizationCallback(this.internalHostApplication.getBaseUrl(), "plugins/servlet/applinks/listApplicationLinks")), (String)PermissionCode.CREDENTIALS_REQUIRED.name()));
    }

    private URI getOAuthAuthorizationCallback(URI baseUrl, String relativeUrl) {
        try {
            return URIUtil.concatenate(baseUrl, relativeUrl);
        }
        catch (URISyntaxException e) {
            LOG.error("Unable to generate OAuthorization Callback from");
            return null;
        }
    }

    private RemoteAccessLevelApplicationLinkUIEntity getRequestFailedEntity(RemoteRequestException e) {
        return new RemoteAccessLevelApplicationLinkUIEntity(e.getRemoteStatusCode(), this.getNonNullMessages(Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.remote.unknown", e.getRemoteStatusMessage()})), this.userManager.getRemoteUser().getUsername(), e.getRequestTypeName(), null);
    }

    private Iterable<String> getNonNullMessages(RemoteAuthFailure e) {
        ArrayList messageI18nKeys = Lists.newArrayList((Object[])new String[]{e.getRemoteStatusMessage(), e.getAuthProblem(), e.getAuthProblemAdvice()});
        return this.getNonNullMessages(messageI18nKeys);
    }

    private Iterable<String> getNonNullMessages(List<String> messageI18nKeys) {
        messageI18nKeys.removeAll(Collections.singleton(null));
        return Iterables.transform(messageI18nKeys, (Function)new Function<String, String>(){

            public String apply(@Nullable String i18nKey) {
                return ApplicationLinkResourceRemote.this.i18nResolver.getText(i18nKey);
            }
        });
    }

    private String getRequestTypeMessage(String requestTypeNameI18nKey) {
        return this.i18nResolver.getText(requestTypeNameI18nKey);
    }
}

