/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.auth.trusted;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.core.auth.AuthenticationAccessLevelService;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.core.auth.trusted.TrustConfigurator;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;

public class TrustedAppAccessLevelService
implements AuthenticationAccessLevelService {
    private final TrustConfigurator trustConfigurator;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final I18nResolver i18nResolver;

    public TrustedAppAccessLevelService(TrustConfigurator trustConfigurator, AuthenticationConfigurationManager authenticationConfigurationManager, I18nResolver i18nResolver) {
        this.trustConfigurator = trustConfigurator;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getIncomingConfiguredAccessLevel(ApplicationLink applicationLink) {
        return this.trustConfigurator.inboundTrustEnabled(applicationLink) ? new Pair((Object)AccessLevel.UNSUPPORTED, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.incoming.trustedapps.configured")})) : new Pair((Object)AccessLevel.ANONYMOUS, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.incoming.trustedapps.notconfigured")}));
    }

    @Override
    public void setIncomingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getOutgoingConfiguredAccessLevel(ApplicationLink applicationLink) {
        return this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), TrustedAppsAuthenticationProvider.class) ? new Pair((Object)AccessLevel.UNSUPPORTED, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.outgoing.trustedapps.configured")})) : new Pair((Object)AccessLevel.ANONYMOUS, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.outgoing.trustedapps.notconfigured")}));
    }

    @Override
    public void setOutgoingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceOutgoingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        return new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.remote.outgoing.trustedapps.unknown"}));
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceIncomingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        return new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.remote.incoming.trustedapps.unknown"}));
    }
}

