/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.auth.oauth;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.core.auth.AuthenticationAccessLevelService;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderStoreService;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.core.rest.model.AuthenticationProviderEntity;
import com.atlassian.applinks.core.rest.model.ConsumerEntity;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.fugue.Pair;
import com.atlassian.oauth.Consumer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAccessLevelService
implements AuthenticationAccessLevelService {
    private static final Logger LOG = LoggerFactory.getLogger((String)OAuthAccessLevelService.class.getName());
    private final ServiceProviderStoreService serviceProviderStoreService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final I18nResolver i18nResolver;

    public OAuthAccessLevelService(ServiceProviderStoreService serviceProviderStoreService, AuthenticationConfigurationManager authenticationConfigurationManager, I18nResolver i18nResolver) {
        this.serviceProviderStoreService = serviceProviderStoreService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getIncomingConfiguredAccessLevel(ApplicationLink applicationLink) {
        ArrayList justifications = Lists.newArrayList();
        Consumer consumer = this.serviceProviderStoreService.getConsumer(applicationLink);
        boolean is3LOConfigured = consumer != null;
        boolean is2LOConfigured = consumer != null && consumer.getTwoLOAllowed();
        boolean is2LOiConfigured = consumer != null && consumer.getTwoLOImpersonationAllowed();
        return this.getOAuthAccessLevel(justifications, is3LOConfigured, is2LOConfigured, is2LOiConfigured);
    }

    @Override
    public void setIncomingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
        boolean setConsumer = this.needs3LO(accessLevel);
        boolean twoLO = this.needs2LO(accessLevel);
        boolean twoLOi = this.needs2LOi(accessLevel);
        if (setConsumer) {
            Consumer consumer = this.serviceProviderStoreService.getConsumer(applicationLink);
            if (consumer == null) {
                try {
                    consumer = OAuthHelper.fetchConsumerInformation(applicationLink);
                }
                catch (ResponseException e) {
                    LOG.warn("Unable to determine the consumer information for link", (Throwable)e);
                }
            }
            if (consumer != null) {
                Consumer updatedConsumer = new Consumer.InstanceBuilder(consumer.getKey()).name(consumer.getName()).description(consumer.getDescription()).publicKey(consumer.getPublicKey()).signatureMethod(consumer.getSignatureMethod()).callback(consumer.getCallback()).twoLOAllowed(twoLO).executingTwoLOUser(consumer.getExecutingTwoLOUser()).twoLOImpersonationAllowed(twoLOi).build();
                this.serviceProviderStoreService.addConsumer(updatedConsumer, applicationLink);
            }
        } else {
            try {
                this.serviceProviderStoreService.removeConsumer(applicationLink);
            }
            catch (IllegalStateException e) {
                LOG.warn("attempt to remove missing consumer on link: " + applicationLink);
            }
        }
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getOutgoingConfiguredAccessLevel(ApplicationLink applicationLink) {
        ArrayList justifications = Lists.newArrayList();
        boolean is3LOConfigured = this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), OAuthAuthenticationProvider.class);
        boolean is2LOConfigured = this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), TwoLeggedOAuthAuthenticationProvider.class);
        boolean is2LOiConfigured = this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class);
        return this.getOAuthAccessLevel(justifications, is3LOConfigured, is2LOConfigured, is2LOiConfigured);
    }

    @Override
    public void setOutgoingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
        boolean threeLO = this.needs3LO(accessLevel);
        boolean twoLO = this.needs2LO(accessLevel);
        boolean twoLOi = this.needs2LOi(accessLevel);
        if (threeLO) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), OAuthAuthenticationProvider.class, Collections.emptyMap());
        } else {
            this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), OAuthAuthenticationProvider.class);
        }
        if (twoLO) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), TwoLeggedOAuthAuthenticationProvider.class, Collections.emptyMap());
        } else {
            this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), TwoLeggedOAuthAuthenticationProvider.class);
        }
        if (twoLOi) {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class, Collections.emptyMap());
        } else {
            this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class);
        }
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceOutgoingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        boolean hasOAuth = false;
        boolean has2LO = false;
        boolean has2LOi = false;
        boolean hasTrusted = false;
        List<AuthenticationProviderEntity> providers = applicationLinkAuthenticationEntity.getConfiguredAuthProviders();
        for (AuthenticationProviderEntity provider : providers) {
            if (provider.getProvider().equals(OAuthAuthenticationProvider.class.getCanonicalName())) {
                hasOAuth = true;
                continue;
            }
            if (provider.getProvider().equals(TwoLeggedOAuthAuthenticationProvider.class.getCanonicalName())) {
                has2LO = true;
                continue;
            }
            if (provider.getProvider().equals(TwoLeggedOAuthWithImpersonationAuthenticationProvider.class.getCanonicalName())) {
                has2LOi = true;
                continue;
            }
            if (!provider.getProvider().equals(TrustedAppsAuthenticationProvider.class.getCanonicalName())) continue;
            hasTrusted = true;
        }
        return this.getLevel(hasTrusted, hasOAuth, has2LO, has2LOi);
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceIncomingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        List<ConsumerEntity> consumers = applicationLinkAuthenticationEntity.getConsumers();
        boolean hasConsumer = false;
        boolean hasConsumer2LO = false;
        boolean hasConsumer2LOi = false;
        for (ConsumerEntity consumer : consumers) {
            hasConsumer = true;
            hasConsumer2LO = consumer.isTwoLOAllowed();
            hasConsumer2LOi = consumer.isTwoLOImpersonationAllowed();
        }
        return this.getLevel(false, hasConsumer, hasConsumer2LO, hasConsumer2LOi);
    }

    private Pair<AccessLevel, Iterable<String>> getOAuthAccessLevel(List<String> justifications, boolean is3LOConfigured, boolean is2LOConfigured, boolean is2LOiConfigured) {
        AccessLevel cumulativeLevel = AccessLevel.ANONYMOUS;
        if (is2LOiConfigured) {
            if (is2LOConfigured && is3LOConfigured) {
                cumulativeLevel = AccessLevel.PREAUTH;
            } else if (is2LOConfigured) {
                cumulativeLevel = AccessLevel.UNSUPPORTED;
                justifications.add(this.i18nResolver.getText(this.getIncomingConfiguredJustification("2loi") + "." + this.getIncomingNotConfiguredJustification("2lo")));
            } else {
                cumulativeLevel = AccessLevel.UNSUPPORTED;
                justifications.add(this.i18nResolver.getText(this.getIncomingConfiguredJustification("2loi") + "." + this.getIncomingNotConfiguredJustification("3lo")));
            }
        } else if (is2LOConfigured) {
            if (is3LOConfigured) {
                cumulativeLevel = AccessLevel.SERVERAUTH;
            } else {
                cumulativeLevel = AccessLevel.UNSUPPORTED;
                justifications.add(this.i18nResolver.getText(this.getIncomingConfiguredJustification("2lo") + "." + this.getIncomingNotConfiguredJustification("3lo")));
            }
        } else if (is3LOConfigured) {
            cumulativeLevel = AccessLevel.USERAUTH;
        }
        return new Pair((Object)cumulativeLevel, justifications);
    }

    private String getIncomingConfiguredJustification(String providerName) {
        return "applinks.accesslevel.incoming." + providerName + ".configured";
    }

    private String getIncomingNotConfiguredJustification(String providerName) {
        return "applinks.accesslevel.incoming." + providerName + ".notconfigured";
    }

    private boolean needs3LO(AccessLevel level) {
        return level == AccessLevel.USERAUTH || level == AccessLevel.SERVERAUTH || level == AccessLevel.PREAUTH;
    }

    private boolean needs2LO(AccessLevel level) {
        return level == AccessLevel.SERVERAUTH || level == AccessLevel.PREAUTH;
    }

    private boolean needs2LOi(AccessLevel level) {
        return level == AccessLevel.PREAUTH;
    }

    private Pair<AccessLevel, Iterable<String>> getLevel(boolean hasTrusted, boolean hasOAuth, boolean has2LO, boolean has2LOi) {
        AccessLevel level = AccessLevel.UNSUPPORTED;
        if (!hasTrusted) {
            level = AccessLevel.ANONYMOUS;
            if (hasOAuth) {
                level = AccessLevel.USERAUTH;
                if (has2LO) {
                    level = AccessLevel.SERVERAUTH;
                    if (has2LOi) {
                        level = AccessLevel.PREAUTH;
                    }
                }
            }
        }
        return new Pair((Object)level, (Object)Lists.newArrayList());
    }
}

