/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AccessLevel {
    UNSUPPORTED(-2),
    UNKNOWN(0),
    ANONYMOUS(1),
    USERAUTH(2),
    SERVERAUTH(3),
    PREAUTH(4);

    public final int level;
    private static final Map<Integer, AccessLevel> levels;

    private AccessLevel(int level) {
        this.level = level;
    }

    public static AccessLevel levelFor(int level) {
        return levels.get(level);
    }

    static {
        levels = Maps.newHashMap();
        for (AccessLevel level : AccessLevel.values()) {
            levels.put(level.level, level);
        }
    }
}

