/**
 * Utility functions for generating URLs in JS, including a link to applinks admin screen.
 */
(function(){
    AppLinks.Urls = {
        /**
         * Generate a url from the base and parameters.
         * @param baseUrl the baseUrl
         * @param parametersMap a map of parameters to add, in the form of { parameterName :  parameterValue }f
         * @return {*}
         */
        generateUrl: function(baseUrl, parametersMap) {
            var redirectUrl = baseUrl;

            if(typeof parametersMap == 'undefined') {
                return redirectUrl;
            } else {
                AJS.$.each(parametersMap, function(key, value) {
                    if(redirectUrl.indexOf('?') < 0) {
                        redirectUrl = redirectUrl + '?';
                    } else {
                        redirectUrl = redirectUrl + '&';
                    }
                    redirectUrl = redirectUrl + key + "=" + encodeURIComponent(JSON.stringify(value))
                });

                return redirectUrl;
            }
        },
        /**
         * Generate a Url based on the Applinks Admin screen.
         * @param remoteBaseUrl
         * @param parametersMap
         * @returns {*}
         */
        generateApplinksAdminUrl : function(baseUrl, typeId, parametersMap) {
            var url = baseUrl + "/plugins/servlet/applinks/listApplicationLinks";
            if(typeId === 'confluence') {
                url = baseUrl + "/admin/listapplicationlinks.action";
            }
            return AppLinks.Urls.generateUrl(url, parametersMap);
        }
    };
})();
