/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.auth;

import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.applinks.ui.auth.ServletSessionHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class PowerUserFilter
implements Filter {
    private static final String LOGIN_SERVLET_PATH = "/plugins/servlet/applinks/login";
    protected final AdminUIAuthenticator uiAuthenticator;

    public PowerUserFilter(AdminUIAuthenticator uiAuthenticator) {
        this.uiAuthenticator = uiAuthenticator;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String password;
        String username;
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!LOGIN_SERVLET_PATH.equals(request.getPathInfo()) && !this.checkAccess(username = request.getParameter("al_username"), password = request.getParameter("al_password"), new ServletSessionHandler(request))) {
            this.handleAccessDenied(request, response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void handleAccessDenied(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(request.getContextPath() + LOGIN_SERVLET_PATH + "?" + "originalUrl" + "=" + this.getOriginalUrl(request) + "&" + "forRole" + "=" + this.getForRole());
    }

    abstract String getForRole();

    abstract boolean checkAccess(String var1, String var2, AdminUIAuthenticator.SessionHandler var3);

    private String getOriginalUrl(HttpServletRequest request) throws UnsupportedEncodingException {
        String originalUrl = request.getContextPath() + request.getServletPath() + request.getPathInfo() + this.sanitiseQueryString(request);
        return URLEncoder.encode(originalUrl, "UTF-8");
    }

    private String sanitiseQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryString = "";
        } else if ((queryString = queryString.replaceAll("(&|^)al_(username|password)=[^&]*", "")).length() > 0) {
            queryString = "?" + queryString;
        }
        return queryString;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

