/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.model;

import com.atlassian.applinks.core.rest.model.LinkedEntity;
import com.atlassian.applinks.core.rest.model.adapter.OptionalURIAdapter;
import com.atlassian.oauth.Consumer;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="consumer")
public class ConsumerEntity
extends LinkedEntity {
    @XmlElement(name="key")
    private String key;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="signatureMethod")
    private Consumer.SignatureMethod signatureMethod;
    @XmlElement(name="publicKey")
    private String publicKey;
    @XmlElement(name="sharedSecret")
    private String sharedSecret;
    @XmlJavaTypeAdapter(value=OptionalURIAdapter.class)
    @XmlElement(name="callback")
    private URI callback;
    @XmlElement(name="twoLOAllowed")
    private Boolean twoLOAllowed;
    @XmlElement(name="executingTwoLOUser")
    private String executingTwoLOUser;
    @XmlElement(name="twoLOImpersonationAllowed")
    private Boolean twoLOImpersonationAllowed;
    @XmlElement(name="outgoing")
    private Boolean outgoing;

    public ConsumerEntity() {
    }

    public ConsumerEntity(Link self, Consumer consumer) {
        if (consumer == null) {
            return;
        }
        this.key = consumer.getKey();
        this.name = consumer.getName();
        this.description = consumer.getDescription();
        this.signatureMethod = consumer.getSignatureMethod();
        if (consumer.getPublicKey() != null) {
            this.publicKey = consumer.getPublicKey().toString();
        }
        this.callback = consumer.getCallback();
        this.twoLOAllowed = consumer.getTwoLOAllowed();
        this.executingTwoLOUser = consumer.getExecutingTwoLOUser();
        this.twoLOImpersonationAllowed = consumer.getTwoLOImpersonationAllowed();
        this.addLink(self);
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Consumer.SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    @Nullable
    public String getPublicKey() {
        return this.publicKey;
    }

    @Nullable
    public URI getCallback() {
        return this.callback;
    }

    public boolean isTwoLOAllowed() {
        return this.twoLOAllowed;
    }

    @Nullable
    public String getExecutingTwoLOUser() {
        return this.executingTwoLOUser;
    }

    public boolean isTwoLOImpersonationAllowed() {
        return this.twoLOImpersonationAllowed;
    }

    @Nullable
    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }
}

