/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.model;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.core.rest.model.LinkedEntity;
import com.atlassian.applinks.core.rest.model.adapter.ApplicationIdAdapter;
import com.atlassian.applinks.core.rest.model.adapter.OptionalURIAdapter;
import com.atlassian.applinks.core.rest.model.adapter.RequiredBaseURIAdapter;
import com.atlassian.applinks.core.rest.model.adapter.TypeIdAdapter;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="applicationLink")
public class ApplicationLinkEntity
extends LinkedEntity {
    @XmlJavaTypeAdapter(value=ApplicationIdAdapter.class)
    private ApplicationId id;
    @XmlJavaTypeAdapter(value=TypeIdAdapter.class)
    private TypeId typeId;
    private String name;
    @XmlJavaTypeAdapter(value=RequiredBaseURIAdapter.class)
    private URI displayUrl;
    @XmlJavaTypeAdapter(value=OptionalURIAdapter.class)
    private URI iconUrl;
    @XmlJavaTypeAdapter(value=RequiredBaseURIAdapter.class)
    private URI rpcUrl;
    private Boolean isPrimary;
    private Boolean isSystem;

    private ApplicationLinkEntity() {
    }

    public ApplicationLinkEntity(ApplicationLink applicationLink, Link self) {
        this(applicationLink.getId(), TypeId.getTypeId((ApplicationType)applicationLink.getType()), applicationLink.getName(), applicationLink.getDisplayUrl(), applicationLink.getType().getIconUrl(), applicationLink.getRpcUrl(), applicationLink.isPrimary(), applicationLink.isSystem(), self);
    }

    public ApplicationLinkEntity(ApplicationId id, TypeId typeId, String name, URI displayUrl, URI iconUrl, URI rpcUrl, Boolean primary, Boolean isSystem, Link self) {
        this.id = id;
        this.typeId = typeId;
        this.name = name;
        this.displayUrl = displayUrl;
        this.iconUrl = iconUrl;
        this.isPrimary = primary;
        this.isSystem = isSystem;
        if (!this.isSystem().booleanValue()) {
            this.rpcUrl = rpcUrl;
        }
        this.addLink(self);
    }

    public ApplicationId getId() {
        return this.id;
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public String getName() {
        return this.name;
    }

    public URI getDisplayUrl() {
        return this.displayUrl;
    }

    public URI getIconUrl() {
        return this.iconUrl;
    }

    public URI getRpcUrl() {
        return this.isSystem() != false ? null : this.rpcUrl;
    }

    public boolean isPrimary() {
        return this.isPrimary != null && this.isPrimary != false;
    }

    public Boolean isSystem() {
        return this.isSystem != null && this.isSystem != false;
    }

    public ApplicationLinkDetails getDetails() {
        return ApplicationLinkDetails.builder().name(this.getName()).displayUrl(this.getDisplayUrl()).rpcUrl(this.getRpcUrl()).isPrimary(this.isPrimary()).build();
    }
}

