/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.link;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.ImpersonatingAuthenticationProvider;
import com.atlassian.applinks.api.auth.NonImpersonatingAuthenticationProvider;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestFactoryFactory;
import com.atlassian.applinks.core.link.InternalApplicationLink;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.spi.application.StaticUrlApplicationType;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.net.URI;

public class DefaultApplicationLink
implements InternalApplicationLink {
    private final ApplicationId id;
    private final ApplicationType type;
    private final ApplicationLinkProperties applicationLinkProperties;
    private final ApplicationLinkRequestFactoryFactory requestFactoryFactory;
    private final EventPublisher eventPublisher;

    public DefaultApplicationLink(ApplicationId serverId, ApplicationType type, ApplicationLinkProperties applicationLinkProperties, ApplicationLinkRequestFactoryFactory requestFactoryFactory, EventPublisher eventPublisher) {
        this.id = (ApplicationId)Preconditions.checkNotNull((Object)serverId);
        this.applicationLinkProperties = (ApplicationLinkProperties)Preconditions.checkNotNull((Object)applicationLinkProperties);
        this.requestFactoryFactory = (ApplicationLinkRequestFactoryFactory)Preconditions.checkNotNull((Object)requestFactoryFactory);
        this.type = (ApplicationType)Preconditions.checkNotNull((Object)type);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
    }

    public void update(ApplicationLinkDetails details) {
        this.applicationLinkProperties.setName(details.getName());
        this.applicationLinkProperties.setDisplayUrl(details.getDisplayUrl());
        this.applicationLinkProperties.setRpcUrl(details.getRpcUrl());
        this.eventPublisher.publish((Object)new ApplicationLinkDetailsChangedEvent((ApplicationLink)this));
    }

    @Override
    public void setPrimaryFlag(boolean isPrimary) {
        this.applicationLinkProperties.setIsPrimary(isPrimary);
    }

    @Override
    public void setSystem(boolean isSystem) {
        this.applicationLinkProperties.setSystem(isSystem);
    }

    public ApplicationId getId() {
        return this.id;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String getName() {
        return this.applicationLinkProperties.getName();
    }

    public URI getDisplayUrl() {
        if (this.type instanceof StaticUrlApplicationType) {
            return ((StaticUrlApplicationType)this.type).getStaticUrl();
        }
        return this.applicationLinkProperties.getDisplayUrl();
    }

    public URI getRpcUrl() {
        if (this.type instanceof StaticUrlApplicationType) {
            return ((StaticUrlApplicationType)this.type).getStaticUrl();
        }
        return this.applicationLinkProperties.getRpcUrl();
    }

    public boolean isPrimary() {
        return this.applicationLinkProperties.isPrimary();
    }

    public boolean isSystem() {
        return this.applicationLinkProperties.isSystem();
    }

    public ApplicationLinkRequestFactory createAuthenticatedRequestFactory() {
        return this.requestFactoryFactory.getApplicationLinkRequestFactory((ApplicationLink)this);
    }

    public ApplicationLinkRequestFactory createAuthenticatedRequestFactory(Class<? extends AuthenticationProvider> providerClass) {
        return this.requestFactoryFactory.getApplicationLinkRequestFactory((ApplicationLink)this, providerClass);
    }

    public ApplicationLinkRequestFactory createImpersonatingAuthenticatedRequestFactory() {
        return this.requestFactoryFactory.getApplicationLinkRequestFactory((ApplicationLink)this, ImpersonatingAuthenticationProvider.class);
    }

    public ApplicationLinkRequestFactory createNonImpersonatingAuthenticatedRequestFactory() {
        return this.requestFactoryFactory.getApplicationLinkRequestFactory((ApplicationLink)this, NonImpersonatingAuthenticationProvider.class);
    }

    public Object getProperty(String key) {
        return this.applicationLinkProperties.getProperty(key);
    }

    public Object putProperty(String key, Object value) {
        return this.applicationLinkProperties.putProperty(key, value);
    }

    public Object removeProperty(String key) {
        return this.applicationLinkProperties.removeProperty(key);
    }

    public String toString() {
        return String.format("%s (%s) %s %s", this.getName(), this.id, this.getRpcUrl(), this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultApplicationLink that = (DefaultApplicationLink)o;
        return !(this.id != null ? !this.id.equals((Object)that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

