/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.trusted;

import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.AbstractApplicationLinkRequest;
import com.atlassian.applinks.core.auth.trusted.TrustedApplinksResponseHandler;
import com.atlassian.applinks.core.auth.trusted.TrustedApplinksReturningResponseHandler;
import com.atlassian.applinks.core.auth.trusted.TrustedResponseHandler;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedRequest
extends AbstractApplicationLinkRequest {
    private static final Logger log = LoggerFactory.getLogger(TrustedRequest.class);
    private final CurrentApplication currentApplication;
    private final String username;

    public TrustedRequest(String url, Request wrappedRequest, CurrentApplication currentApplication, String username) {
        super(url, wrappedRequest);
        this.currentApplication = currentApplication;
        this.username = username;
    }

    public <R> R execute(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.execute(new TrustedApplinksResponseHandler<R>(applicationLinkResponseHandler, this, this.followRedirects));
    }

    public void execute(ResponseHandler responseHandler) throws ResponseException {
        this.signRequest();
        this.wrappedRequest.execute(new TrustedResponseHandler((ResponseHandler<Response>)responseHandler, this, this.followRedirects));
    }

    public <R> R executeAndReturn(ReturningResponseHandler<Response, R> returningResponseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.executeAndReturn(new TrustedApplinksReturningResponseHandler(returningResponseHandler, this, this.followRedirects));
    }

    @Override
    public void signRequest() throws ResponseException {
        this.signRequest(this.unsignedRequest());
    }

    public void signRequest(com.atlassian.security.auth.trustedapps.request.TrustedRequest unsignedRequest) {
        if (log.isDebugEnabled()) {
            log.debug("signRequest - signing request for url:" + this.url);
        }
        TrustedApplicationUtils.addRequestParameters((EncryptedCertificate)this.currentApplication.encode(this.username, this.url), (com.atlassian.security.auth.trustedapps.request.TrustedRequest)unsignedRequest);
    }

    public com.atlassian.security.auth.trustedapps.request.TrustedRequest unsignedRequest() {
        return new com.atlassian.security.auth.trustedapps.request.TrustedRequest(){

            public void addRequestParameter(String name, String value) {
                TrustedRequest.this.wrappedRequest.setHeader(name, value);
            }
        };
    }
}

