/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.trusted;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.core.auth.AbstractSysadminOnlyAuthServlet;
import com.atlassian.applinks.core.auth.trusted.Action;
import com.atlassian.applinks.core.auth.trusted.TrustConfigurator;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.core.util.RendererContextBuilder;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.ui.AbstractApplinksServlet;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

abstract class AbstractTrustedAppsServlet
extends AbstractSysadminOnlyAuthServlet {
    public static final String TRUSTED_APPS_INCOMING_ID = "trustedapps.incoming.applicationId";
    protected static final String VM_TEMPLATE = "auth/trusted/config.vm";
    protected final TrustedApplicationsConfigurationManager trustedAppsManager;
    protected final AuthenticationConfigurationManager configurationManager;
    protected final TrustedApplicationsManager trustedApplicationsManager;
    protected final TrustConfigurator trustConfigurator;

    protected AbstractTrustedAppsServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, AdminUIAuthenticator adminUIAuthenticator, ApplicationLinkService applicationLinkService, InternalHostApplication internalHostApplication, TrustedApplicationsManager trustedApplicationsManager, AuthenticationConfigurationManager configurationManager, TrustedApplicationsConfigurationManager trustedAppsManager, TrustConfigurator trustConfigurator, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, LoginUriProvider loginUriProvider, DocumentationLinker documentationLinker, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, UserManager userManager) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, applicationLinkService, adminUIAuthenticator, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator, userManager);
        this.trustedAppsManager = trustedAppsManager;
        this.trustedApplicationsManager = trustedApplicationsManager;
        this.configurationManager = configurationManager;
        this.trustConfigurator = trustConfigurator;
    }

    protected Action getAction(HttpServletRequest request) {
        String value = this.getRequiredParameter(request, "action");
        try {
            return Action.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new AbstractApplinksServlet.BadRequestException(this.messageFactory.newI18nMessage("auth.trusted.config.reciprocal.action.missing", new Serializable[]{value}));
        }
    }

    @Override
    protected List<String> getRequiredWebResources() {
        return ImmutableList.of((Object)"com.atlassian.applinks.applinks-plugin:trusted-auth");
    }

    protected boolean peerHasUAL(HttpServletRequest request) {
        return !request.getServletPath().endsWith("-non-ual");
    }

    protected void render(HttpServletRequest request, HttpServletResponse response, String consumer, String consumerAppType, String provider, String providerAppType, boolean enabled, Map<String, Object> renderContext) throws IOException {
        Object view = renderContext.get("view");
        String role = request.getServletPath().replaceFirst(".*/([^/?]+).*", "$1").startsWith("inbound") ? "provider" : "consumer";
        this.render(VM_TEMPLATE, new RendererContextBuilder(renderContext).put("stringUtils", new StringUtils()).put("enabled", enabled).put("view", ObjectUtils.defaultIfNull((Object)view, (Object)(enabled ? "enabled" : "disabled"))).put("nonUAL", !this.peerHasUAL(request)).put("formLocation", request.getContextPath() + request.getServletPath() + request.getPathInfo()).put("consumer", consumer).put("consumerAppType", consumerAppType).put("providerAppType", providerAppType).put("provider", provider).put("role", role).build(), request, response);
    }
}

