/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.twolo.impersonation;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.core.auth.oauth.twolo.TwoLeggedOAuthRequest;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.ImmutableList;

public class TwoLeggedOAuthWithImpersonationRequest
extends TwoLeggedOAuthRequest {
    private static final String XOAUTH_REQUESTOR_ID = "xoauth_requestor_id";
    private String username;

    public TwoLeggedOAuthWithImpersonationRequest(String url, Request.MethodType methodType, Request wrappedRequest, ServiceProvider serviceProvider, ConsumerService consumerService, ApplicationId applicationId, String username) {
        super(url, methodType, wrappedRequest, serviceProvider, consumerService, applicationId);
        this.username = username;
    }

    @Override
    protected void signRequest() throws ResponseException {
        this.wrappedRequest.setUrl(this.addUsernameToUrl(this.url));
        this.parameters.put(XOAUTH_REQUESTOR_ID, ImmutableList.of((Object)this.username));
        super.signRequest();
    }

    private String addUsernameToUrl(String url) {
        if (url.contains("?")) {
            return url + "&" + XOAUTH_REQUESTOR_ID + "=" + this.username;
        }
        return url + "?" + XOAUTH_REQUESTOR_ID + "=" + this.username;
    }
}

