/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.OAuthRedirectingApplicationLinkResponseHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;

public class OAuthResponseHandler<T extends Response>
extends OAuthRedirectingApplicationLinkResponseHandler
implements ResponseHandler<Response> {
    private final ResponseHandler<Response> responseHandler;

    public OAuthResponseHandler(ResponseHandler<Response> responseHandler, ConsumerTokenStoreService consumerTokenStoreService, ApplicationLinkRequest wrappedRequest, ApplicationId applicationId, String username, boolean followRedirects) {
        super(wrappedRequest, consumerTokenStoreService, applicationId, username, followRedirects);
        this.responseHandler = responseHandler;
    }

    public OAuthResponseHandler(ResponseHandler<Response> responseHandler, ApplicationLinkRequest wrappedRequest, ApplicationId applicationId, boolean followRedirects) {
        super(wrappedRequest, null, applicationId, null, followRedirects);
        this.responseHandler = responseHandler;
    }

    public void handle(Response response) throws ResponseException {
        this.checkForOAuthProblemAndRemoveConsumerTokenIfNecessary(response);
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            this.wrappedRequest.execute((ResponseHandler)this);
        } else {
            this.responseHandler.handle(response);
        }
    }
}

