/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.AbstractApplicationLinkRequest;
import com.atlassian.applinks.core.auth.oauth.OAuthApplinksResponseHandler;
import com.atlassian.applinks.core.auth.oauth.OAuthApplinksReturningResponseHandler;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.OAuthResponseHandler;
import com.atlassian.oauth.Request;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.oauth.OAuthMessage;

public abstract class OAuthRequest
extends AbstractApplicationLinkRequest {
    protected final Request.MethodType methodType;
    protected final ApplicationId applicationId;
    protected final ServiceProvider serviceProvider;
    protected final ConsumerService consumerService;

    public OAuthRequest(String url, Request.MethodType methodType, Request wrappedRequest, ApplicationId applicationId, ServiceProvider serviceProvider, ConsumerService consumerService) {
        super(url, wrappedRequest);
        this.methodType = methodType;
        this.applicationId = applicationId;
        this.serviceProvider = serviceProvider;
        this.consumerService = consumerService;
    }

    public <R> R execute(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.execute(new OAuthApplinksResponseHandler<R>(applicationLinkResponseHandler, this, this.applicationId, this.followRedirects));
    }

    public void execute(ResponseHandler responseHandler) throws ResponseException {
        this.signRequest();
        this.wrappedRequest.execute(new OAuthResponseHandler((ResponseHandler<Response>)responseHandler, this.wrappedRequest, this.applicationId, this.followRedirects));
    }

    public <R> R executeAndReturn(ReturningResponseHandler<Response, R> returningResponseHandler) throws ResponseException {
        this.signRequest();
        return (R)this.wrappedRequest.executeAndReturn(new OAuthApplinksReturningResponseHandler(returningResponseHandler, this.wrappedRequest, this.applicationId, this.followRedirects));
    }

    @Override
    protected void signRequest() throws ResponseException {
        com.atlassian.oauth.Request oAuthRequest = this.createUnsignedRequest();
        com.atlassian.oauth.Request signedRequest = this.consumerService.sign(oAuthRequest, this.serviceProvider);
        OAuthMessage oAuthMessage = OAuthHelper.asOAuthMessage(signedRequest);
        try {
            this.wrappedRequest.setHeader("Authorization", oAuthMessage.getAuthorizationHeader(null));
        }
        catch (IOException e) {
            throw new ResponseException("Unable to generate OAuth Authorization request header.", (Throwable)e);
        }
    }

    protected abstract com.atlassian.oauth.Request createUnsignedRequest();

    protected List<Request.Parameter> toOAuthParameters(String accesstoken) {
        ArrayList<Request.Parameter> parameters = new ArrayList<Request.Parameter>();
        parameters.add(new Request.Parameter("oauth_token", accesstoken));
        for (String parameterName : this.parameters.keySet()) {
            List values = (List)this.parameters.get(parameterName);
            for (String value : values) {
                parameters.add(new Request.Parameter(parameterName, value));
            }
        }
        return parameters;
    }

    protected static Request.HttpMethod toOAuthMethodType(Request.MethodType methodType) {
        Request.HttpMethod method = Request.HttpMethod.GET;
        if (methodType == Request.MethodType.GET) {
            method = Request.HttpMethod.GET;
        } else if (methodType == Request.MethodType.POST) {
            method = Request.HttpMethod.POST;
        } else if (methodType == Request.MethodType.PUT) {
            method = Request.HttpMethod.PUT;
        } else if (methodType == Request.MethodType.DELETE) {
            method = Request.HttpMethod.DELETE;
        }
        return method;
    }
}

