/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.core.auth.AbstractApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.sal.api.net.Response;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthRedirectingApplicationLinkResponseHandler
extends AbstractApplicationLinkResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthRedirectingApplicationLinkResponseHandler.class);
    protected static final Set<String> TOKEN_PROBLEMS = ImmutableSet.of((Object)"token_expired", (Object)"token_rejected", (Object)"token_revoked");
    protected final ConsumerTokenStoreService consumerTokenStoreService;
    protected final ApplicationId applicationId;
    protected final String username;
    protected boolean hasTokenProblems = false;

    public OAuthRedirectingApplicationLinkResponseHandler(ApplicationLinkRequest wrappedRequest, ConsumerTokenStoreService consumerTokenStoreService, ApplicationId applicationId, String username, boolean followRedirects) {
        super(wrappedRequest, followRedirects);
        this.consumerTokenStoreService = consumerTokenStoreService;
        this.username = username;
        this.applicationId = applicationId;
    }

    protected void checkForOAuthProblemAndRemoveConsumerTokenIfNecessary(Response response) {
        String value = (String)response.getHeaders().get("WWW-Authenticate");
        if (!StringUtils.isBlank((String)value)) {
            for (OAuth.Parameter parameter : OAuthMessage.decodeAuthorization((String)value)) {
                if (!"oauth_problem".equals(parameter.getKey())) continue;
                log.debug("OAuth request rejected by peer.\nOur OAuth request header: Authorization: " + this.wrappedRequest.getHeaders().get("Authorization") + "\n" + "Full OAuth response header: WWW-Authenticate: " + value);
                if ("timestamp_refused".equals(parameter.getValue())) {
                    log.warn("Peer rejected the timestamp on our OAuth request. This might be due to a replay attack, but it's more likely our system clock is not synchronized with the server's clock. You may turn on debug logging to log the full contents of the OAuth response headers.");
                }
                if (this.consumerTokenStoreService == null || !TOKEN_PROBLEMS.contains(parameter.getValue())) continue;
                try {
                    this.consumerTokenStoreService.removeConsumerToken(this.applicationId, this.username);
                }
                catch (RuntimeException e) {
                    log.error("Failed to delete consumer token for user '" + this.username + "'.", (Throwable)e);
                }
                this.hasTokenProblems = true;
            }
        }
    }
}

