/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.RequestUtil;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderStoreService;
import com.atlassian.applinks.core.auth.oauth.ThreeLeggedOAuthRequestFactoryImpl;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationDirection;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.auth.AutoConfiguringAuthenticatorProviderPluginModule;
import com.atlassian.applinks.spi.auth.IncomingTrustAuthenticationProviderPluginModule;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.api.user.UserManager;
import java.net.URI;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Version;

public class OAuthAuthenticatorProviderPluginModule
implements AutoConfiguringAuthenticatorProviderPluginModule,
IncomingTrustAuthenticationProviderPluginModule {
    public static final String ADD_CONSUMER_MANUALLY_SERVLET_LOCATION = "/plugins/servlet/applinks/auth/conf/oauth/add-consumer-manually/";
    public static final String ADD_CONSUMER_BY_URL_SERVLET_LOCATION = "/plugins/servlet/applinks/auth/conf/oauth/add-consumer-by-url/";
    public static final String OUTBOUND_NON_APPLINKS_SERVLET_LOCATION = "/plugins/servlet/applinks/auth/conf/oauth/outbound/3rdparty/";
    public static final String OUTBOUND_ATLASSIAN_SERVLET_LOCATION = "/plugins/servlet/applinks/auth/conf/oauth/outbound/atlassian/";
    public static final String OUTBOUND_ATLASSIAN_REDIRECT_LOCATION = "/plugins/servlet/applinks/auth/conf/oauth/outbound/apl-redirect/";
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ConsumerService consumerService;
    private final ConsumerTokenStoreService consumerTokenStoreService;
    private final InternalHostApplication hostApplication;
    private final RequestFactory requestFactory;
    private final UserManager userManager;
    private final ServiceProviderStoreService serviceProviderStoreService;

    public OAuthAuthenticatorProviderPluginModule(AuthenticationConfigurationManager authenticationConfigurationManager, ConsumerService consumerService, ConsumerTokenStoreService consumerTokenStoreService, InternalHostApplication hostApplication, RequestFactory requestFactory, UserManager userManager, ServiceProviderStoreService serviceProviderStoreService) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.consumerService = consumerService;
        this.consumerTokenStoreService = consumerTokenStoreService;
        this.hostApplication = hostApplication;
        this.requestFactory = requestFactory;
        this.userManager = userManager;
        this.serviceProviderStoreService = serviceProviderStoreService;
    }

    public AuthenticationProvider getAuthenticationProvider(final ApplicationLink link) {
        OAuthAuthenticationProvider provider = null;
        if (this.authenticationConfigurationManager.isConfigured(link.getId(), OAuthAuthenticationProvider.class)) {
            provider = new OAuthAuthenticationProvider(){

                public ApplicationLinkRequestFactory getRequestFactory(String username) {
                    return new ThreeLeggedOAuthRequestFactoryImpl(link, OAuthAuthenticatorProviderPluginModule.this.authenticationConfigurationManager, OAuthAuthenticatorProviderPluginModule.this.consumerService, OAuthAuthenticatorProviderPluginModule.this.consumerTokenStoreService, OAuthAuthenticatorProviderPluginModule.this.requestFactory, OAuthAuthenticatorProviderPluginModule.this.userManager, (HostApplication)OAuthAuthenticatorProviderPluginModule.this.hostApplication);
                }
            };
        }
        return provider;
    }

    public String getConfigUrl(ApplicationLink link, Version applicationLinksVersion, AuthenticationDirection direction, HttpServletRequest request) {
        boolean supportsAppLinks = applicationLinksVersion != null;
        boolean oAuthPluginInstalled = OAuthHelper.isOAuthPluginInstalled(link);
        String configUri = direction == AuthenticationDirection.OUTBOUND ? RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + OUTBOUND_ATLASSIAN_REDIRECT_LOCATION + link.getId().toString() + "?" + "supportsAppLinks" + "=" + supportsAppLinks : (supportsAppLinks || oAuthPluginInstalled ? RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + ADD_CONSUMER_BY_URL_SERVLET_LOCATION + link.getId().toString() + "?" + "uiposition" + "=local" : RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) + ADD_CONSUMER_MANUALLY_SERVLET_LOCATION + link.getId().toString());
        return configUri;
    }

    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass() {
        return OAuthAuthenticationProvider.class;
    }

    public boolean isApplicable(AuthenticationScenario authenticationScenario, ApplicationLink applicationLink) {
        return authenticationScenario.isTrusted();
    }

    public void enable(RequestFactory authenticatedRequestFactory, ApplicationLink applicationLink) throws AuthenticationConfigurationException {
        this.enableRemoteTrust(authenticatedRequestFactory, applicationLink);
        try {
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), OAuthAuthenticationProvider.class, Collections.emptyMap());
            Consumer consumer = OAuthHelper.fetchConsumerInformation(applicationLink);
            this.serviceProviderStoreService.addConsumer(consumer, applicationLink);
        }
        catch (Exception e) {
            throw new AuthenticationConfigurationException("Failed to auto-configure OAuth authentication locally for application link '" + applicationLink + "'", (Throwable)e);
        }
    }

    public void disable(RequestFactory authenticatedRequestFactory, ApplicationLink applicationLink) throws AuthenticationConfigurationException {
        this.consumerTokenStoreService.removeAllConsumerTokens(applicationLink);
        this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), OAuthAuthenticationProvider.class);
        this.serviceProviderStoreService.removeConsumer(applicationLink);
        this.disableRemoteTrust(authenticatedRequestFactory, applicationLink);
    }

    private void enableRemoteTrust(RequestFactory<Request<Request<?, Response>, Response>> requestFactory, ApplicationLink applicationLink) throws AuthenticationConfigurationException {
        this.configureRemoteTrust(requestFactory, applicationLink, Request.MethodType.PUT);
    }

    private void disableRemoteTrust(RequestFactory<Request<Request<?, Response>, Response>> requestFactory, ApplicationLink applicationLink) throws AuthenticationConfigurationException {
        this.configureRemoteTrust(requestFactory, applicationLink, Request.MethodType.DELETE);
    }

    private void configureRemoteTrust(RequestFactory<Request<Request<?, Response>, Response>> authenticatedRequestFactory, ApplicationLink applicationLink, Request.MethodType action) throws AuthenticationConfigurationException {
        boolean autoConfigSuccessful;
        URI autoConfigUrl = URIUtil.uncheckedConcatenate(applicationLink.getRpcUrl(), "/plugins/servlet/applinks/auth/conf/oauth/autoconfig/" + this.hostApplication.getId().toString());
        Request request = authenticatedRequestFactory.createRequest(action, autoConfigUrl.toString());
        request.addHeader("X-Atlassian-Token", "no-check");
        try {
            autoConfigSuccessful = (Boolean)request.executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Boolean>(){

                public Boolean handle(Response response) throws ResponseException {
                    return response.isSuccessful();
                }
            });
        }
        catch (ResponseException e) {
            autoConfigSuccessful = false;
        }
        if (!autoConfigSuccessful) {
            throw new AuthenticationConfigurationException("Failed to auto-configure OAuth authentication in remote application. Application link '" + applicationLink + "'");
        }
    }

    public boolean incomingEnabled(ApplicationLink applicationLink) {
        return this.serviceProviderStoreService.getConsumer(applicationLink) != null;
    }
}

