/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.OAuthRedirectingApplicationLinkResponseHandler;
import com.atlassian.applinks.core.auth.oauth.OAuthRequest;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthApplinksResponseHandler<R>
extends OAuthRedirectingApplicationLinkResponseHandler
implements ApplicationLinkResponseHandler<R> {
    private static final Logger log = LoggerFactory.getLogger(OAuthApplinksResponseHandler.class);
    private final ApplicationLinkResponseHandler<R> applicationLinkResponseHandler;

    public OAuthApplinksResponseHandler(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler, ConsumerTokenStoreService consumerTokenStoreService, OAuthRequest wrappedRequest, ApplicationId applicationId, String username, boolean followRedirects) {
        super(wrappedRequest, consumerTokenStoreService, applicationId, username, followRedirects);
        this.applicationLinkResponseHandler = applicationLinkResponseHandler;
    }

    public OAuthApplinksResponseHandler(ApplicationLinkResponseHandler<R> applicationLinkResponseHandler, OAuthRequest wrappedRequest, ApplicationId applicationId, boolean followRedirects) {
        super(wrappedRequest, null, applicationId, null, followRedirects);
        this.applicationLinkResponseHandler = applicationLinkResponseHandler;
    }

    public R credentialsRequired(Response response) throws ResponseException {
        return (R)this.applicationLinkResponseHandler.credentialsRequired(response);
    }

    public R handle(Response response) throws ResponseException {
        this.checkForOAuthProblemAndRemoveConsumerTokenIfNecessary(response);
        if (this.hasTokenProblems) {
            return (R)this.applicationLinkResponseHandler.credentialsRequired(response);
        }
        if (this.followRedirects && this.redirectHelper.responseShouldRedirect(response)) {
            this.wrappedRequest.setUrl(this.redirectHelper.getNextRedirectLocation(response));
            return (R)this.wrappedRequest.execute((ApplicationLinkResponseHandler)this);
        }
        return (R)this.applicationLinkResponseHandler.handle(response);
    }
}

