/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.core.plugin.AuthenticationProviderModuleDescriptor;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;

public class AuthenticatorAccessor {
    private final PluginAccessor pluginAccessor;

    public AuthenticatorAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public <T extends AuthenticationProvider> T getAuthenticationProvider(ApplicationLink applicationLink, Class<T> providerClass) {
        Preconditions.checkNotNull((Object)applicationLink);
        Preconditions.checkNotNull(providerClass);
        for (AuthenticationProviderPluginModule module : this.getAllAuthenticationProviderPluginModules()) {
            AuthenticationProvider provider = module.getAuthenticationProvider(applicationLink);
            if (provider == null || !providerClass.isAssignableFrom(provider.getClass())) continue;
            return (T)provider;
        }
        return null;
    }

    public Iterable<AuthenticationProviderPluginModule> getAllAuthenticationProviderPluginModules() {
        ArrayList descriptors = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(AuthenticationProviderModuleDescriptor.class));
        Collections.sort(descriptors, AuthenticationProviderModuleDescriptor.BY_WEIGHT);
        return Iterables.transform((Iterable)descriptors, (Function)new Function<AuthenticationProviderModuleDescriptor, AuthenticationProviderPluginModule>(){

            public AuthenticationProviderPluginModule apply(AuthenticationProviderModuleDescriptor from) {
                return from.getModule();
            }
        });
    }
}

