/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.event.ApplicationLinkAuthConfigChangedEvent;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.Map;

public class AuthenticationConfigurationManagerImpl
implements AuthenticationConfigurationManager {
    private final ApplicationLinkService applicationLinkService;
    private final PropertyService propertyService;
    private final EventPublisher eventPublisher;

    public AuthenticationConfigurationManagerImpl(ApplicationLinkService applicationLinkService, PropertyService propertyService, EventPublisher eventPublisher) {
        this.applicationLinkService = applicationLinkService;
        this.propertyService = propertyService;
        this.eventPublisher = eventPublisher;
    }

    public Map<String, String> getConfiguration(ApplicationId id, Class<? extends AuthenticationProvider> provider) {
        this.assertApplicationLinkPresence(id);
        return this.propertyService.getApplicationLinkProperties(id).getProviderConfig(this.getPrefixForProvider(provider));
    }

    public boolean isConfigured(ApplicationId id, Class<? extends AuthenticationProvider> provider) {
        return this.propertyService.getApplicationLinkProperties(id).authProviderIsConfigured(this.getPrefixForProvider(provider));
    }

    public void registerProvider(ApplicationId id, Class<? extends AuthenticationProvider> provider, Map<String, String> config) {
        this.assertApplicationLinkPresence(id);
        ApplicationLinkProperties props = this.propertyService.getApplicationLinkProperties(id);
        props.setProviderConfig(this.getPrefixForProvider(provider), config);
        this.publishChangeEvent(id);
    }

    public void unregisterProvider(ApplicationId id, Class<? extends AuthenticationProvider> provider) {
        this.assertApplicationLinkPresence(id);
        ApplicationLinkProperties props = this.propertyService.getApplicationLinkProperties(id);
        props.removeProviderConfig(this.getPrefixForProvider(provider));
        this.publishChangeEvent(id);
    }

    private void assertApplicationLinkPresence(ApplicationId id) {
        ApplicationLink applicationLink = this.getApplicationLink(id);
        if (applicationLink == null) {
            throw new IllegalArgumentException(String.format("Application Link \"%s\" not found.", id));
        }
    }

    private ApplicationLink getApplicationLink(ApplicationId id) {
        ApplicationLink applicationLink;
        try {
            applicationLink = this.applicationLinkService.getApplicationLink(id);
        }
        catch (TypeNotInstalledException e) {
            throw new IllegalStateException(String.format("Failed to load application link %s as type %s is no longer installed.", id, e.getType()));
        }
        return applicationLink;
    }

    private String getPrefixForProvider(Class<? extends AuthenticationProvider> provider) {
        return ((Class)Preconditions.checkNotNull(provider, (Object)"AuthenticationProvider")).getName();
    }

    private void publishChangeEvent(ApplicationId id) {
        ApplicationLink link = this.getApplicationLink(id);
        if (link != null) {
            this.eventPublisher.publish((Object)new ApplicationLinkAuthConfigChangedEvent(link));
        }
    }
}

