/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.AuthorisationAdminURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.ImpersonatingAuthenticationProvider;
import com.atlassian.applinks.api.auth.NonImpersonatingAuthenticationProvider;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestAdaptor;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestFactoryFactory;
import com.atlassian.applinks.core.auth.AuthenticatorAccessor;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLinkRequestFactoryFactoryImpl
implements ApplicationLinkRequestFactoryFactory {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkRequestFactoryFactoryImpl.class);
    private final AuthenticatorAccessor authenticatorAccessor;
    private final ApplicationLinkRequestFactory delegateRequestFactory;
    private final UserManager userManager;

    public ApplicationLinkRequestFactoryFactoryImpl(RequestFactory<Request<?, ?>> requestFactory, UserManager userManager, AuthenticatorAccessor authenticatorAccessor) {
        this.authenticatorAccessor = (AuthenticatorAccessor)Preconditions.checkNotNull((Object)authenticatorAccessor);
        this.delegateRequestFactory = new SalRequestFactoryAdapter((RequestFactory)Preconditions.checkNotNull(requestFactory));
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    @Override
    public ApplicationLinkRequestFactory getApplicationLinkRequestFactory(ApplicationLink link) {
        Preconditions.checkNotNull((Object)link);
        String username = this.userManager.getRemoteUsername();
        if (username == null) {
            log.debug("No current user context. Outgoing requests will be anonymous");
            return this.createAnonymousRequestFactory(link);
        }
        ApplicationLinkRequestFactory factory = this.createImpersonatingRequestFactory(link, ImpersonatingAuthenticationProvider.class, username);
        if (factory == null && (factory = this.createNonImpersonatingRequestFactory(link, NonImpersonatingAuthenticationProvider.class)) == null) {
            log.debug("No authenticator configured for link '{}', outgoing requests will be anonymous", (Object)link);
            factory = this.createAnonymousRequestFactory(link);
        }
        return factory;
    }

    @Override
    public ApplicationLinkRequestFactory getApplicationLinkRequestFactory(ApplicationLink link, Class<? extends AuthenticationProvider> providerClass) {
        Preconditions.checkNotNull((Object)link);
        Preconditions.checkNotNull(providerClass);
        if (Anonymous.class.isAssignableFrom(providerClass)) {
            return this.createAnonymousRequestFactory(link);
        }
        if (ImpersonatingAuthenticationProvider.class.isAssignableFrom(providerClass)) {
            return this.createImpersonatingRequestFactory(link, providerClass);
        }
        if (NonImpersonatingAuthenticationProvider.class.isAssignableFrom(providerClass)) {
            return this.createNonImpersonatingRequestFactory(link, providerClass);
        }
        throw new IllegalArgumentException(String.format("Only AuthenticationProviders that are subclasses of %s, %s or %s are supported", ImpersonatingAuthenticationProvider.class.getSimpleName(), NonImpersonatingAuthenticationProvider.class.getSimpleName(), Anonymous.class.getSimpleName()));
    }

    private ApplicationLinkRequestFactory createAnonymousRequestFactory(ApplicationLink link) {
        return AbsoluteURLRequestFactory.create(this.delegateRequestFactory, link);
    }

    private ApplicationLinkRequestFactory createImpersonatingRequestFactory(ApplicationLink link, Class<? extends AuthenticationProvider> providerClass) {
        String username = this.userManager.getRemoteUsername();
        if (username == null) {
            log.debug("Cannot create request factory with authentication provider '{}' without current user context.", (Object)providerClass.getName());
            return null;
        }
        return this.createImpersonatingRequestFactory(link, providerClass, username);
    }

    private ApplicationLinkRequestFactory createImpersonatingRequestFactory(ApplicationLink link, Class<? extends AuthenticationProvider> providerClass, String username) {
        AuthenticationProvider authenticationProvider = this.authenticatorAccessor.getAuthenticationProvider(link, providerClass);
        if (authenticationProvider == null) {
            return null;
        }
        return AbsoluteURLRequestFactory.create(((ImpersonatingAuthenticationProvider)authenticationProvider).getRequestFactory(username), link);
    }

    private ApplicationLinkRequestFactory createNonImpersonatingRequestFactory(ApplicationLink link, Class<? extends AuthenticationProvider> providerClass) {
        AuthenticationProvider authenticationProvider = this.authenticatorAccessor.getAuthenticationProvider(link, providerClass);
        if (authenticationProvider == null) {
            return null;
        }
        return AbsoluteURLRequestFactory.create(((NonImpersonatingAuthenticationProvider)authenticationProvider).getRequestFactory(), link);
    }

    protected static class SalRequestFactoryAdapter
    implements ApplicationLinkRequestFactory {
        private final RequestFactory<Request<?, ?>> adaptedFactory;

        public SalRequestFactoryAdapter(RequestFactory<Request<?, ?>> requestFactory) {
            this.adaptedFactory = requestFactory;
        }

        public URI getAuthorisationURI() {
            return null;
        }

        public URI getAuthorisationURI(URI callback) {
            return null;
        }

        public ApplicationLinkRequest createRequest(Request.MethodType methodType, String url) {
            return new ApplicationLinkRequestAdaptor(this.adaptedFactory.createRequest(methodType, url));
        }
    }

    protected static class AbsoluteURLRequestFactoryWithAdminURI
    extends AbsoluteURLRequestFactory
    implements AuthorisationAdminURIGenerator {
        private AuthorisationAdminURIGenerator adminUriGenerator;

        public AbsoluteURLRequestFactoryWithAdminURI(ApplicationLinkRequestFactory requestFactory, AuthorisationAdminURIGenerator adminUriGenerator, ApplicationLink link) {
            super(requestFactory, link);
            this.adminUriGenerator = adminUriGenerator;
        }

        public URI getAuthorisationAdminURI() {
            return this.adminUriGenerator.getAuthorisationAdminURI();
        }
    }

    protected static class AbsoluteURLRequestFactory
    implements ApplicationLinkRequestFactory {
        protected final ApplicationLinkRequestFactory requestFactory;
        private final ApplicationLink link;

        public static ApplicationLinkRequestFactory create(ApplicationLinkRequestFactory requestFactory, ApplicationLink link) {
            if (requestFactory instanceof AuthorisationAdminURIGenerator) {
                return new AbsoluteURLRequestFactoryWithAdminURI(requestFactory, (AuthorisationAdminURIGenerator)requestFactory, link);
            }
            return new AbsoluteURLRequestFactory(requestFactory, link);
        }

        public AbsoluteURLRequestFactory(ApplicationLinkRequestFactory requestFactory, ApplicationLink link) {
            this.requestFactory = (ApplicationLinkRequestFactory)Preconditions.checkNotNull((Object)requestFactory);
            this.link = (ApplicationLink)Preconditions.checkNotNull((Object)link);
        }

        public ApplicationLinkRequest createRequest(Request.MethodType methodType, String uri) throws CredentialsRequiredException {
            Preconditions.checkNotNull((Object)uri);
            boolean isAbsoluteUri = false;
            try {
                isAbsoluteUri = new URI(uri).isAbsolute();
            }
            catch (URISyntaxException e) {
                log.warn("Couldn't parse uri '{}' supplied to RequestFactory.createRequest(), assuming relative.", (Object)uri);
            }
            String updatedUri = isAbsoluteUri ? uri : this.link.getRpcUrl() + (uri.startsWith("/") ? uri : "/" + uri);
            Preconditions.checkArgument((boolean)updatedUri.startsWith(this.link.getRpcUrl().toString()), (Object)"Request url doesn't match rpc url configured");
            return this.requestFactory.createRequest(methodType, updatedUri);
        }

        public URI getAuthorisationURI() {
            return this.requestFactory.getAuthorisationURI();
        }

        public URI getAuthorisationURI(URI callback) {
            return this.requestFactory.getAuthorisationURI(callback);
        }
    }
}

