package com.atlassian.applinks.ui.auth;

/**
 * Servlet filter for urls that require sysadmin privilege to access.
 *
 * @since 3.0
 */
public class AdminFilter extends PowerUserFilter
{
    public AdminFilter(AdminUIAuthenticator uiAuthenticator)
    {
        super(uiAuthenticator);
    }

    @Override
    String getForRole()
    {
        return "admin";
    }

    @Override
    boolean checkAccess(String username, String password, AdminUIAuthenticator.SessionHandler sessionHandler)
    {
        return uiAuthenticator.checkAdminUIAccessBySessionOrPasswordAndActivateAdminSession(username, password, sessionHandler);
    }
}
