package com.atlassian.applinks.ui;

import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.applinks.ui.velocity.ListApplicationLinksContext;
import com.atlassian.applinks.ui.velocity.VelocityContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * A servlet that renders a velocity template to display all configured linked applications.
 *
 * @since 3.0
 */
public class ListApplicationLinksServlet extends AbstractAppLinksAdminOnlyServlet
{
    private static final String TEMPLATE_PATH = "com/atlassian/applinks/ui/admin/list_application_links.vm";
    private static final String WEB_RESOURCE_CONTEXT = "applinks.list.application.links";

    private static final String IS_SYSADMIN = "isSysadmin";

    private final VelocityContextFactory velocityContextFactory;
    private final WebSudoManager webSudoManager;
    private final UserManager userManager;


    public ListApplicationLinksServlet(final I18nResolver i18nResolver,
                                       final MessageFactory messageFactory,
                                       final TemplateRenderer templateRenderer,
                                       final WebResourceManager webResourceManager,
                                       final AdminUIAuthenticator adminUIAuthenticator,
                                       final InternalHostApplication internalHostApplication,
                                       final BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory,
                                       final DocumentationLinker documentationLinker,
                                       final LoginUriProvider loginUriProvider,
                                       final VelocityContextFactory velocityContextFactory,
                                       final WebSudoManager webSudoManager,
                                       final XsrfTokenAccessor xsrfTokenAccessor,
                                       final XsrfTokenValidator xsrfTokenValidator,
                                       final UserManager userManager)
    {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, adminUIAuthenticator,
                batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication,
                xsrfTokenAccessor, xsrfTokenValidator);
        this.velocityContextFactory = velocityContextFactory;
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
    }

    @Override
    protected List<String> getRequiredWebResourceContexts()
    {
        return ImmutableList.of(WEB_RESOURCE_CONTEXT);
    }

    @Override
    protected void doGet(final HttpServletRequest request, final HttpServletResponse response)
            throws ServletException, IOException
    {
        try
        {
            // Enable web sudo protection if needed and if the app we are running in supports it
            webSudoManager.willExecuteWebSudoRequest(request);

            // NOTE: Confluence does not use the ListApplicationLinksServlet, any changes to the context after construction by
            // the velocityContextFactory need to be duplicated in ListApplicationLinksAction    
            final ListApplicationLinksContext context = velocityContextFactory.buildListApplicationLinksContext(request);
            render(TEMPLATE_PATH, ImmutableMap.<String, Object>of("context", context), request, response);
        }
        catch (WebSudoSessionException wse)
        {
            webSudoManager.enforceWebSudoProtection(request, response);
        }
    }
}
