package com.atlassian.applinks.core.util;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;

import java.util.Set;

/**
 * Get base url of documentation. For use in soy templates.
 * @since 4.0.0
 */
public class GetDocumentationBaseUrlFunction implements SoyServerFunction<String>, SoyClientFunction{

    private final InternalHostApplication internalHostApplication;

    public GetDocumentationBaseUrlFunction(final InternalHostApplication internalHostApplication)
    {
        this.internalHostApplication = internalHostApplication;
    }

    public String getName() {
        return "getDocumentationBaseUrl";
    }

    public JsExpression generate(JsExpression... jsExpressions) {
        return new JsExpression("'" + internalHostApplication.getDocumentationBaseUrl().toString() + "'");
    }

    public String apply(Object... objects) {
        return internalHostApplication.getDocumentationBaseUrl().toString();
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of(0);
    }
}
