package com.atlassian.applinks.core.rest.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;

import com.atlassian.plugins.rest.common.Link;

/**
 * Base class for entities. Provides links.
 */
@XmlSeeAlso({ApplicationLinkEntity.class, AuthenticationProviderEntity.class, ConsumerEntity.class})
public class LinkedEntity
{
    @XmlElement(name="link")
    private List<Link> links;

    public void addLink(Link link)
    {
        if(links==null)
            links = new ArrayList<Link>();
        links.add(link);
    }
}

