package com.atlassian.applinks.core.rest.model;

import java.util.List;

import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.atlassian.plugins.rest.common.Link;

/**
 * Entity containing the currently configured authentication providers for a specified link
 *
 * @since 3.12
 */
@XmlRootElement (name = "applicationLinkAuthentication")
public class ApplicationLinkAuthenticationEntity extends LinkedEntity
{
    @XmlElement (name = "configuredAuthProviders")
    private List<AuthenticationProviderEntity> configuredAuthenticationProviders;

    @XmlElement (name = "consumers")
    private List<ConsumerEntity> consumers;

    public ApplicationLinkAuthenticationEntity()
    {

    }

    public ApplicationLinkAuthenticationEntity(final Link self, final List<ConsumerEntity> consumers, final List<AuthenticationProviderEntity> configuredAuthenticationProviders)
    {
        this.configuredAuthenticationProviders = configuredAuthenticationProviders;
        this.consumers = consumers;
        addLink(self);
    }

    @Nullable
    public List<AuthenticationProviderEntity> getConfiguredAuthProviders()
    {
        return this.configuredAuthenticationProviders;
    }

    @Nullable
    public List<ConsumerEntity> getConsumers()
    {
        return this.consumers;
    }
}
