package com.atlassian.applinks.core.auth.oauth.twolo.impersonation;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.twolo.AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderStoreService;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.RequestFactory;

/**
 * Plugin module implemenation for 2-legged OAuth with Impersonation authentication.
 *
 * @since 3.10
 */
public class TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule extends AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule
{
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ConsumerService consumerService;
    private final RequestFactory requestFactory;
    private final ServiceProviderStoreService serviceProviderStoreService;

    public TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule(
            final AuthenticationConfigurationManager authenticationConfigurationManager,
            final ConsumerService consumerService,
            final InternalHostApplication hostApplication,
            final RequestFactory requestFactory,
            final ServiceProviderStoreService serviceProviderStoreService)
    {
        super(hostApplication);
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.consumerService = consumerService;
        this.requestFactory = requestFactory;
        this.serviceProviderStoreService = serviceProviderStoreService;
    }

    public AuthenticationProvider getAuthenticationProvider(final ApplicationLink link)
    {
        AuthenticationProvider provider = null;

        if (authenticationConfigurationManager.isConfigured(link.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class))
        {
            provider = new TwoLeggedOAuthWithImpersonationAuthenticationProvider()
            {
                public ApplicationLinkRequestFactory getRequestFactory(String username)
                {
                    return new TwoLeggedOAuthWithImpersonationRequestFactoryImpl(link,
                                                                                 authenticationConfigurationManager,
                                                                                 consumerService,
                                                                                 requestFactory,
                                                                                 username);
                }
            };
        }
        return provider;
    }

    public boolean incomingEnabled(final ApplicationLink applicationLink)
    {
        final Consumer consumer = serviceProviderStoreService.getConsumer(applicationLink);
        return consumer != null && consumer.getTwoLOAllowed() && consumer.getTwoLOImpersonationAllowed();
    }

    @Override
    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass()
    {
        return TwoLeggedOAuthWithImpersonationAuthenticationProvider.class;
    }
}
