package com.atlassian.applinks.core.auth.oauth;

import java.util.List;

import com.atlassian.sal.api.net.ResponseException;

import com.google.common.collect.ImmutableList;

import net.oauth.OAuth;

/**
 * Thrown when an OAuthMessage containing a problem is received.
 * 
 * @since 3.11.1
 *
 */
public class OAuthMessageProblemException extends ResponseException
{
    /**
     * The Oauth parameters returned in the OAuthMessage.
     */
    final ImmutableList<OAuth.Parameter> parameters;

    public OAuthMessageProblemException(final String message)
    {
        super(message);
        parameters = null;
    }

    public OAuthMessageProblemException(final String message, final List<OAuth.Parameter> parameters)
    {
        super(message);
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public ImmutableList<OAuth.Parameter> getParameters() {
        return parameters;
    }
}
