package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @since 3.2
 */
public class OAuthApplinksResponseHandler<R> extends OAuthRedirectingApplicationLinkResponseHandler implements ApplicationLinkResponseHandler<R>
{
    private static final Logger log = LoggerFactory.getLogger(OAuthApplinksResponseHandler.class);

    private final ApplicationLinkResponseHandler<R> applicationLinkResponseHandler;

    public OAuthApplinksResponseHandler(
            ApplicationLinkResponseHandler<R> applicationLinkResponseHandler,
            ConsumerTokenStoreService consumerTokenStoreService,
            OAuthRequest wrappedRequest,
            ApplicationId applicationId,
            String username,
            boolean followRedirects)
    {
        super(wrappedRequest, consumerTokenStoreService, applicationId, username, followRedirects);
        this.applicationLinkResponseHandler = applicationLinkResponseHandler;
    }

    public OAuthApplinksResponseHandler(
            ApplicationLinkResponseHandler<R> applicationLinkResponseHandler,
            OAuthRequest wrappedRequest,
            ApplicationId applicationId,
            boolean followRedirects)
    {
        super(wrappedRequest, null, applicationId, null, followRedirects);
        this.applicationLinkResponseHandler = applicationLinkResponseHandler;
    }

    public R credentialsRequired(Response response) throws ResponseException
    {
        return applicationLinkResponseHandler.credentialsRequired(response);
    }

    public R handle(Response response) throws ResponseException
    {
        checkForOAuthProblemAndRemoveConsumerTokenIfNecessary(response);
        if (hasTokenProblems)
        {
            return applicationLinkResponseHandler.credentialsRequired(response);
        }


        if (followRedirects && redirectHelper.responseShouldRedirect(response))
        {
            wrappedRequest.setUrl(redirectHelper.getNextRedirectLocation(response));
            return wrappedRequest.execute(this);
        }

        return applicationLinkResponseHandler.handle(response);
    }
}
