package com.atlassian.applinks.core.auth;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Base class for application link requests.
 *
 * @since 3.11.0
 */
public abstract class AbstractApplicationLinkRequest implements ApplicationLinkRequest
{
    private static final Logger log = LoggerFactory.getLogger(AbstractApplicationLinkRequest.class);

    protected String url;
    protected final ApplicationLinkRequest wrappedRequest;
    protected final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    protected boolean followRedirects = true;

    public AbstractApplicationLinkRequest(final String url, final Request wrappedRequest)
    {
        this.url = url;
        this.wrappedRequest = new ApplicationLinkRequestAdaptor(wrappedRequest);
        this.wrappedRequest.setFollowRedirects(false);
    }

    public ApplicationLinkRequest setConnectionTimeout(final int i)
    {
        wrappedRequest.setConnectionTimeout(i);
        return this;
    }

    public ApplicationLinkRequest setSoTimeout(final int i)
    {
        wrappedRequest.setSoTimeout(i);
        return this;
    }

    public ApplicationLinkRequest setUrl(final String s)
    {
        this.url = s;
        wrappedRequest.setUrl(s);
        return this;
    }

    public ApplicationLinkRequest setRequestBody(final String s)
    {
        wrappedRequest.setRequestBody(s);
        return this;
    }

    public ApplicationLinkRequest setFiles(final List<RequestFilePart> files)
    {
        wrappedRequest.setFiles(files);
        return this;
    }

    public ApplicationLinkRequest setEntity(final Object o)
    {
        wrappedRequest.setEntity(o);
        return this;
    }

    public ApplicationLinkRequest setRequestContentType(final String s)
    {
        wrappedRequest.setRequestContentType(s);
        return this;
    }

    public ApplicationLinkRequest addRequestParameters(final String... params)
    {
        wrappedRequest.addRequestParameters(params);
        for (int i = 0; i < params.length; i += 2)
        {
            final String name = params[i];
            final String value = params[i + 1];
            List<String> list = parameters.get(name);
            if (list == null)
            {
                list = new ArrayList<String>();
                parameters.put(name, list);
            }
            list.add(value);
        }

        return this;
    }

    public ApplicationLinkRequest addAuthentication(final Authenticator authenticator)
    {
        wrappedRequest.addAuthentication(authenticator);
        return this;
    }

    public ApplicationLinkRequest addTrustedTokenAuthentication()
    {
        wrappedRequest.addTrustedTokenAuthentication();
        return this;
    }

    public ApplicationLinkRequest addTrustedTokenAuthentication(final String s)
    {
        wrappedRequest.addTrustedTokenAuthentication(s);
        return this;
    }

    public ApplicationLinkRequest addBasicAuthentication(final String s, final String s1)
    {
        wrappedRequest.addBasicAuthentication(s, s1);
        return this;
    }

    public ApplicationLinkRequest addSeraphAuthentication(final String s, final String s1)
    {
        wrappedRequest.addSeraphAuthentication(s, s1);
        return this;
    }

    public ApplicationLinkRequest addHeader(final String s, final String s1)
    {
        wrappedRequest.addHeader(s, s1);
        return this;
    }

    public ApplicationLinkRequest setHeader(final String s, final String s1)
    {
        wrappedRequest.setHeader(s, s1);
        return this;
    }

    public Map<String, List<String>> getHeaders()
    {
        return wrappedRequest.getHeaders();
    }

    public ApplicationLinkRequest setFollowRedirects(final boolean followRedirects)
    {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean getFollowRedirects()
    {
        return followRedirects;
    }

    public String execute() throws ResponseException {
        signRequest();
        return executeAndReturn(new ApplicationLinksStringReturningResponseHandler());
    }

    protected abstract void signRequest() throws ResponseException;
}