package com.atlassian.applinks.core;

import com.atlassian.applinks.core.util.RendererContextBuilder;
import com.atlassian.applinks.core.util.WebResources;
import com.atlassian.applinks.ui.validators.CallbackParameterValidator;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.templaterenderer.TemplateRenderer;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class RedirectController
{
    public static final String REDIRECT_WARRNING_TEMPLATE = "/auth/invalidRedirectUrl.vm";
    private final CallbackParameterValidator callbackParameterValidator;
    private final TemplateRenderer templateRenderer;
    private final WebResourceManager webResourceManager;

    public RedirectController(final CallbackParameterValidator callbackParameterValidator, final TemplateRenderer templateRenderer, final WebResourceManager webResourceManager)
    {
        this.callbackParameterValidator = callbackParameterValidator;
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
    }

    public void redirectOrPrintRedirectionWarning(final HttpServletResponse response, String redirectUrl) throws IOException
    {
        final boolean callbackUrlValid = callbackParameterValidator.isCallbackUrlValid(redirectUrl);

        if (callbackUrlValid)
        {
            response.sendRedirect(redirectUrl);
        }
        else
        {
            printRedirectWarningMessage(redirectUrl, response);
        }
    }

    private void printRedirectWarningMessage(final String redirectUrl, final HttpServletResponse response) throws IOException
    {
        response.setContentType("text/html");
        final Map<String, Object> context = buildMessageContext(redirectUrl);
        templateRenderer.render(REDIRECT_WARRNING_TEMPLATE, context, response.getWriter());
    }

    private Map<String, Object> buildMessageContext(final String redirectUrl)
    {
        final RendererContextBuilder builder = new RendererContextBuilder();
        webResourceManager.requireResource("com.atlassian.applinks.applinks-plugin:oauth-dance");
        final StringWriter stringWriter = new StringWriter();
        webResourceManager.includeResources(stringWriter, UrlMode.RELATIVE);
        final WebResources webResources = new WebResources();
        webResources.setIncludedResources(stringWriter.getBuffer().toString());
        builder.put("webResources", webResources);
        builder.put("redirectUrl", redirectUrl);
        return builder.build();
    }

}
