package com.atlassian.applinks.application.stash;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.api.application.stash.StashProjectEntityType;
import com.atlassian.applinks.application.IconizedIdentifiableType;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.spi.application.NonAppLinksEntityType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;

import java.net.URI;

public class StashProjectEntityTypeImpl extends IconizedIdentifiableType
        implements StashProjectEntityType, NonAppLinksEntityType
{
    private static final TypeId TYPE_ID = new TypeId("stash.project");

    public StashProjectEntityTypeImpl(AppLinkPluginUtil pluginUtil, WebResourceUrlProvider webResourceUrlProvider)
    {
        super(pluginUtil, webResourceUrlProvider);
    }

    public TypeId getId()
    {
        return TYPE_ID;
    }

    public String getI18nKey()
    {
        return "applinks.stash.project";
    }

    public String getPluralizedI18nKey()
    {
        return "applinks.stash.project.plural";
    }

    public String getShortenedI18nKey()
    {
        return "applinks.stash.project.short";
    }

    public Class<? extends ApplicationType> getApplicationType()
    {
        return StashApplicationType.class;
    }

    public URI getDisplayUrl(final ApplicationLink link, final String project)
    {
        Assertions.isTrue(String.format("Application link %s is not of type %s",
                link.getId(), getApplicationType().getName()),
                link.getType() instanceof StashApplicationType);

        return URIUtil.uncheckedConcatenate(link.getDisplayUrl(), "projects", project);
    }
}
