package com.atlassian.applinks.application.stash;

import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.application.IconizedIdentifiableType;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.spi.application.NonAppLinksApplicationType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;

public class StashApplicationTypeImpl extends IconizedIdentifiableType implements StashApplicationType, NonAppLinksApplicationType
{
    static final TypeId TYPE_ID = new TypeId("stash");

    public StashApplicationTypeImpl(AppLinkPluginUtil pluginUtil, WebResourceUrlProvider webResourceUrlProvider)
    {
        super(pluginUtil, webResourceUrlProvider);
    }

    public TypeId getId()
    {
        return TYPE_ID;
    }

    public String getI18nKey()
    {
        return "applinks.stash";
    }
}
