package com.atlassian.applinks.application.crowd;

import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.application.IconizedIdentifiableType;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.spi.application.NonAppLinksApplicationType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;

/**
 * Crowd Application Type
 *
 * @since v3.11
 */
public class CrowdApplicationTypeImpl extends IconizedIdentifiableType implements CrowdApplicationType, NonAppLinksApplicationType
{
    public static final TypeId TYPE_ID = new TypeId("crowd");

    public CrowdApplicationTypeImpl(final AppLinkPluginUtil pluginUtil, final WebResourceUrlProvider webResourceUrlProvider)
    {
        super(pluginUtil, webResourceUrlProvider);
    }

    public String getI18nKey()
    {
        return "applinks.crowd";
    }

    public TypeId getId()
    {
        return TYPE_ID;
    }
}
