/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.cors.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.cors.auth.CorsService;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaults;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class AppLinksCorsDefaults
implements CorsDefaults {
    private final CorsService corsService;

    public AppLinksCorsDefaults(CorsService corsService) {
        this.corsService = corsService;
    }

    public boolean allowsOrigin(String uri) {
        return CollectionUtils.isNotEmpty(this.corsService.getApplicationLinksByOrigin(uri));
    }

    public boolean allowsCredentials(String uri) throws IllegalArgumentException {
        Collection<ApplicationLink> links = this.corsService.getRequiredApplicationLinksByOrigin(uri);
        for (ApplicationLink link : links) {
            if (this.corsService.allowsCredentials(link)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getAllowedRequestHeaders(String uri) throws IllegalArgumentException {
        return this.allowsCredentials(uri) ? ImmutableSet.of((Object)"Authorization") : Collections.emptySet();
    }

    public Set<String> getAllowedResponseHeaders(String uri) throws IllegalArgumentException {
        this.corsService.getRequiredApplicationLinksByOrigin(uri);
        return Collections.emptySet();
    }
}

