/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.cors.rest;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsFilter
implements Filter {
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ORIGIN = "Origin";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TRUE = String.valueOf(true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Enumeration originHeaders = request.getHeaders(ACCESS_CONTROL_ALLOW_ORIGIN);
        Enumeration credentialsHeaders = request.getHeaders(ACCESS_CONTROL_ALLOW_CREDENTIALS);
        if (!originHeaders.hasMoreElements()) {
            String origin = request.getHeader(ORIGIN);
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
            this.logger.debug("CORS Header [{}] set to [{}]", (Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)origin);
        } else if (this.logger.isDebugEnabled()) {
            while (originHeaders.hasMoreElements()) {
                this.logger.debug("CORS Header [{}] NOT   set. It is already set as [{}]", (Object)ACCESS_CONTROL_ALLOW_ORIGIN, originHeaders.nextElement());
            }
        }
        if (!credentialsHeaders.hasMoreElements()) {
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, TRUE);
            this.logger.debug("CORS Header [{}] set to [{}]", (Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)TRUE);
        } else if (this.logger.isDebugEnabled()) {
            while (originHeaders.hasMoreElements()) {
                this.logger.debug("CORS Header [{}] NOT set. It is already set as [{}]", (Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, originHeaders.nextElement());
            }
        }
        if (request.getMethod().equals("OPTIONS")) {
            response.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, CONTENT_TYPE);
            this.logger.debug("CORS Preflight Header [{}] set to [{}]", (Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)CONTENT_TYPE);
            response.addHeader(ACCESS_CONTROL_ALLOW_METHODS, request.getMethod());
            this.logger.debug("CORS Preflight Header [{}] set to [{}]", (Object)ACCESS_CONTROL_ALLOW_METHODS, (Object)request.getMethod());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

