/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.cors.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.auth.types.CorsAuthenticationProvider;
import com.atlassian.applinks.core.util.RequestUtil;
import com.atlassian.applinks.cors.auth.CorsService;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultCorsService
implements CorsService {
    public static final String KEY_ALLOWS_CREDENTIALS = "allowsCredentials";
    private final AuthenticationConfigurationManager configurationManager;
    private final ApplicationLinkService linkService;

    public DefaultCorsService(ApplicationLinkService applicationLinkService, AuthenticationConfigurationManager authenticationConfigurationManager) {
        this.configurationManager = authenticationConfigurationManager;
        this.linkService = applicationLinkService;
    }

    @Override
    public boolean allowsCredentials(ApplicationLink link) {
        Map configuration = this.configurationManager.getConfiguration(link.getId(), CorsAuthenticationProvider.class);
        return configuration != null && "true".equals(configuration.get(KEY_ALLOWS_CREDENTIALS));
    }

    @Override
    public void disableCredentials(ApplicationLink link) {
        this.configurationManager.unregisterProvider(link.getId(), CorsAuthenticationProvider.class);
    }

    @Override
    public void enableCredentials(ApplicationLink link) {
        ImmutableMap configuration = ImmutableMap.of((Object)KEY_ALLOWS_CREDENTIALS, (Object)"true");
        this.configurationManager.registerProvider(link.getId(), CorsAuthenticationProvider.class, (Map)configuration);
    }

    @Override
    public Collection<ApplicationLink> getApplicationLinksByOrigin(String origin) {
        return this.getApplicationLinksByUri(URI.create(origin).normalize());
    }

    @Override
    public Collection<ApplicationLink> getApplicationLinksByUri(URI uri) {
        ArrayList<ApplicationLink> matches = new ArrayList<ApplicationLink>();
        for (ApplicationLink link : this.linkService.getApplicationLinks()) {
            if (!this.matchesOrigin(uri, link.getRpcUrl())) continue;
            matches.add(link);
        }
        return matches;
    }

    @Override
    public Collection<ApplicationLink> getRequiredApplicationLinksByOrigin(String origin) {
        Collection<ApplicationLink> links = this.getApplicationLinksByOrigin(origin);
        if (CollectionUtils.isEmpty(links)) {
            throw new IllegalArgumentException("Origin [" + origin + "] is required to match at least one ApplicationLink");
        }
        return links;
    }

    private boolean matchesOrigin(URI origin, URI link) {
        link = link.normalize();
        return StringUtils.equalsIgnoreCase((String)origin.getHost(), (String)link.getHost()) && this.normalizePort(origin) == this.normalizePort(link) && StringUtils.equalsIgnoreCase((String)origin.getScheme(), (String)link.getScheme());
    }

    private int normalizePort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = RequestUtil.getDefaultPort((String)uri.getScheme());
        }
        return port;
    }
}

