/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import io.atlassian.fugue.Option;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;

final class PluginDateTimeUtils {
    private static final DateTimeFormatter BUILD_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendOffset("+HHMM", "Z").toFormatter();

    private PluginDateTimeUtils() {
    }

    static Option<ZonedDateTime> fromPluginString(String date) {
        try {
            return Option.some((Object)ZonedDateTime.parse(date, BUILD_DATE_FORMAT));
        }
        catch (DateTimeParseException e) {
            return Option.none();
        }
    }

    static String toPluginString(ZonedDateTime date) {
        return date.format(BUILD_DATE_FORMAT);
    }
}

