/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.plugin.ApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataBuilder;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class DefaultApplicationMetaDataModuleDescriptor
extends AbstractModuleDescriptor<PluginApplicationMetaData>
implements ApplicationMetaDataModuleDescriptor {
    private volatile PluginApplicationMetaData metaData;

    public DefaultApplicationMetaDataModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        PluginApplicationMetaDataBuilder builder = new PluginApplicationMetaDataBuilder();
        builder.key(DefaultApplicationMetaDataModuleDescriptor.parseKey(element)).descriptionKey(DefaultApplicationMetaDataModuleDescriptor.getRequiredElement(element, "applicationDescriptionKey")).userCountKey(DefaultApplicationMetaDataModuleDescriptor.getRequiredElement(element, "userCountKey")).name(DefaultApplicationMetaDataModuleDescriptor.getRequiredElement(element, "applicationName")).configURI(DefaultApplicationMetaDataModuleDescriptor.getOptionalURI(element, "configURI")).postInstallURI(DefaultApplicationMetaDataModuleDescriptor.getOptionalURI(element, "postInstallURI")).postUpdateURI(DefaultApplicationMetaDataModuleDescriptor.getOptionalURI(element, "postUpdateURI")).productHelpServerSpaceURI(DefaultApplicationMetaDataModuleDescriptor.getOptionalURI(element, "productHelpServerSpaceURI")).productHelpCloudSpaceURI(DefaultApplicationMetaDataModuleDescriptor.getOptionalURI(element, "productHelpCloudSpaceURI")).definitionModuleKey(this.getCompleteKey()).primaryPlugin(plugin).applicationPlugins(DefaultApplicationMetaDataModuleDescriptor.parsePlugins(element, "applicationPlugins")).defaultGroup(DefaultApplicationMetaDataModuleDescriptor.getRequiredElement(element, "defaultGroup")).utilityPlugins(DefaultApplicationMetaDataModuleDescriptor.parsePlugins(element, "utilityPlugins"));
        this.metaData = builder.build();
    }

    public PluginApplicationMetaData getModule() {
        return this.metaData;
    }

    private static ApplicationKey parseKey(Element element) {
        String key = DefaultApplicationMetaDataModuleDescriptor.getRequiredElement(element, "applicationKey");
        try {
            return ApplicationKey.valueOf((String)key);
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(String.format("productKey '%s' is not valid.", key), (Throwable)e);
        }
    }

    private static Option<URI> getOptionalURI(Element root, final String name) {
        return DefaultApplicationMetaDataModuleDescriptor.getOptionalElement(root, name).map((java.util.function.Function)new Function<String, URI>(){

            public URI apply(@Nullable String input) {
                try {
                    return new URI(input);
                }
                catch (URISyntaxException e) {
                    throw new PluginParseException(String.format("The value '%s' in element '%s' is not a valid URI.", input, name), (Throwable)e);
                }
            }
        });
    }

    private static String getRequiredElement(Element root, String name) {
        Element productKey = root.element(name);
        if (productKey == null) {
            throw new PluginParseException(String.format("Element '%s' is required.", name));
        }
        String value = StringUtils.stripToNull((String)productKey.getText());
        if (value == null) {
            throw new PluginParseException(String.format("Element '%s' must have a value.", name));
        }
        return value;
    }

    private static Option<String> getOptionalElement(Element root, String name) {
        Element element = root.element(name);
        if (element == null) {
            return Option.none();
        }
        String value = StringUtils.stripToNull((String)element.getText());
        if (value == null) {
            return Option.none();
        }
        return Option.some((Object)value);
    }

    private static Iterable<String> parsePlugins(Element root, String name) {
        Element plugins = root.element(name);
        if (plugins == null) {
            return Collections.emptyList();
        }
        List pluginElements = plugins.elements("plugin");
        LinkedHashSet keys = Sets.newLinkedHashSet();
        for (Element pluginElement : pluginElements) {
            String pluginKey = StringUtils.stripToNull((String)pluginElement.getText());
            if (pluginKey == null) {
                throw new PluginParseException(String.format("Plugin '%s' element must have a value.", name));
            }
            keys.add(pluginKey);
        }
        return keys;
    }

    @Override
    public ApplicationKey getApplicationKey() {
        return this.getModule().getKey();
    }

    private static final class Elements {
        private static final String KEY = "applicationKey";
        private static final String NAME = "applicationName";
        private static final String CONFIG_URI = "configURI";
        private static final String POST_INSTALL_URI = "postInstallURI";
        private static final String POST_UPDATE_URI = "postUpdateURI";
        private static final String PRODUCT_HELP_SERVER_SPACE_URI = "productHelpServerSpaceURI";
        private static final String PRODUCT_HELP_CLOUD_SPACE_URI = "productHelpCloudSpaceURI";
        private static final String PLUGIN = "plugin";
        private static final String APPLICATION_PLUGINS = "applicationPlugins";
        private static final String UTILITY_PLUGINS = "utilityPlugins";
        private static final String DESCRIPTION = "applicationDescriptionKey";
        private static final String USER_COUNT = "userCountKey";
        private static final String DEFAULT_GROUP = "defaultGroup";

        private Elements() {
        }
    }
}

